/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.mapping.config;

import java.util.HashMap;
import java.util.Map;
import org.jboss.security.config.ModuleOption;
import org.jboss.security.mapping.MappingType;

public class MappingModuleEntry {
    private final String mappingModuleName;
    private final String mappingModuleType;
    private final Map<String, Object> options;

    public MappingModuleEntry(String name) {
        this(name, new HashMap<String, Object>());
    }

    public MappingModuleEntry(String name, Map<String, Object> options) {
        this(name, options, MappingType.ROLE.toString());
    }

    public MappingModuleEntry(String name, Map<String, Object> options, String type) {
        this.mappingModuleName = name;
        this.mappingModuleType = type;
        this.options = options;
    }

    public void add(ModuleOption option) {
        this.options.put(option.getName(), option.getValue());
    }

    public String getMappingModuleName() {
        return this.mappingModuleName;
    }

    public String getMappingModuleType() {
        return this.mappingModuleType;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName()).append("{");
        builder.append(this.mappingModuleName).append("-").append(this.mappingModuleType);
        builder.append(":").append(this.options);
        builder.append("}");
        return builder.toString();
    }
}

