/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.otlp.internal;

import com.fasterxml.jackson.core.JsonGenerator;
import io.opentelemetry.exporter.otlp.internal.JsonSerializer;
import io.opentelemetry.exporter.otlp.internal.ProtoSerializer;
import io.opentelemetry.exporter.otlp.internal.Serializer;
import java.io.IOException;
import java.io.OutputStream;

public abstract class Marshaler {
    public final void writeBinaryTo(OutputStream output) throws IOException {
        try (ProtoSerializer serializer = new ProtoSerializer(output);){
            this.writeTo(serializer);
        }
    }

    public final void writeJsonTo(OutputStream output) throws IOException {
        try (JsonSerializer serializer = new JsonSerializer(output);){
            serializer.writeMessageValue(this);
        }
    }

    public final void writeJsonTo(JsonGenerator output) throws IOException {
        try (JsonSerializer serializer = new JsonSerializer(output);){
            serializer.writeMessageValue(this);
        }
    }

    public abstract int getBinarySerializedSize();

    protected abstract void writeTo(Serializer var1) throws IOException;
}

