/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.ejb.infinispan.group;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.wildfly.clustering.ejb.infinispan.BeanGroupEntry;
import org.wildfly.clustering.marshalling.spi.MarshalledValue;

public class InfinispanBeanGroupEntry<I, T, C>
implements BeanGroupEntry<I, T, C>,
Function<I, AtomicInteger> {
    private final MarshalledValue<Map<I, T>, C> beans;
    private final Map<I, AtomicInteger> usage = new ConcurrentHashMap<I, AtomicInteger>();

    public InfinispanBeanGroupEntry(MarshalledValue<Map<I, T>, C> beans) {
        this.beans = beans;
    }

    @Override
    public MarshalledValue<Map<I, T>, C> getBeans() {
        return this.beans;
    }

    @Override
    public int incrementUsage(I id) {
        return this.usage.computeIfAbsent(id, this).getAndIncrement();
    }

    @Override
    public int decrementUsage(I id) {
        AtomicInteger count = this.usage.get(id);
        return count != null ? count.decrementAndGet() : 0;
    }

    @Override
    public int totalUsage() {
        int total = 0;
        for (AtomicInteger usage : this.usage.values()) {
            total += usage.get();
        }
        return total;
    }

    @Override
    public AtomicInteger apply(I key) {
        return new AtomicInteger(0);
    }
}

