/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.js;

import io.undertow.UndertowLogger;
import io.undertow.server.Connectors;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.AttachmentKey;
import io.undertow.util.SameThreadExecutor;
import io.undertow.util.StringReadChannelListener;
import java.io.IOException;

public class StringReadHandler
implements HttpHandler {
    public static final AttachmentKey<String> DATA = AttachmentKey.create(String.class);
    private final HttpHandler next;

    public StringReadHandler(HttpHandler next) {
        this.next = next;
    }

    public void handleRequest(final HttpServerExchange exchange) throws Exception {
        if (!exchange.isRequestComplete()) {
            exchange.dispatch(SameThreadExecutor.INSTANCE, new Runnable(){

                @Override
                public void run() {
                    new StringReadChannelListener(exchange.getConnection().getBufferPool()){

                        protected void stringDone(String string) {
                            exchange.putAttachment(DATA, (Object)string);
                            Connectors.executeRootHandler((HttpHandler)StringReadHandler.this.next, (HttpServerExchange)exchange);
                        }

                        protected void error(IOException e) {
                            UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                            exchange.setResponseCode(500);
                            exchange.endExchange();
                        }
                    }.setup(exchange.getRequestChannel());
                }
            });
        } else {
            this.next.handleRequest(exchange);
        }
    }
}

