/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.math.BigDecimal;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.as.messaging.AddressSettingDefinition;
import org.jboss.as.messaging.BridgeDefinition;
import org.jboss.as.messaging.ClusterConnectionDefinition;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.HTTPAcceptorDefinition;
import org.jboss.as.messaging.MessagingExtension;
import org.jboss.as.messaging.jms.ConnectionFactoryDefinition;
import org.jboss.as.messaging.jms.PooledConnectionFactoryDefinition;
import org.jboss.dmr.ModelNode;

public class MessagingTransformers {
    static void registerTransformers(SubsystemRegistration subsystem) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)subsystem.getSubsystemVersion());
        MessagingTransformers.buildTransformers2_1_0(chainedBuilder.createBuilder(subsystem.getSubsystemVersion(), MessagingExtension.VERSION_2_1_0));
        MessagingTransformers.buildTransformers2_0_0(chainedBuilder.createBuilder(MessagingExtension.VERSION_2_1_0, MessagingExtension.VERSION_2_0_0));
        MessagingTransformers.buildTransformers1_4_0(chainedBuilder.createBuilder(MessagingExtension.VERSION_2_0_0, MessagingExtension.VERSION_1_4_0));
        MessagingTransformers.buildTransformers1_3_0(chainedBuilder.createBuilder(MessagingExtension.VERSION_1_4_0, MessagingExtension.VERSION_1_3_0));
        chainedBuilder.buildAndRegister(subsystem, (ModelVersion[][])new ModelVersion[][]{{MessagingExtension.VERSION_1_3_0, MessagingExtension.VERSION_1_4_0, MessagingExtension.VERSION_2_0_0, MessagingExtension.VERSION_2_1_0}});
    }

    private static void buildTransformers2_1_0(ResourceTransformationDescriptionBuilder builder) {
        ResourceTransformationDescriptionBuilder hornetqServer = builder.addChildResource(PathElement.pathElement((String)"hornetq-server"));
        ResourceTransformationDescriptionBuilder addressSetting = hornetqServer.addChildResource(AddressSettingDefinition.PATH);
        MessagingTransformers.rejectDefinedAttributeWithDefaultValue(addressSetting, new AttributeDefinition[]{AddressSettingDefinition.MAX_REDELIVERY_DELAY, AddressSettingDefinition.REDELIVERY_MULTIPLIER});
        ResourceTransformationDescriptionBuilder bridge = hornetqServer.addChildResource(BridgeDefinition.PATH);
        bridge.getAttributeBuilder().setValueConverter((AttributeConverter)new DoubleToBigDecimalConverter(), new AttributeDefinition[]{CommonAttributes.RETRY_INTERVAL_MULTIPLIER});
        ResourceTransformationDescriptionBuilder clusterConnection = hornetqServer.addChildResource(ClusterConnectionDefinition.PATH);
        clusterConnection.getAttributeBuilder().setValueConverter((AttributeConverter)new DoubleToBigDecimalConverter(), new AttributeDefinition[]{CommonAttributes.RETRY_INTERVAL_MULTIPLIER});
        ResourceTransformationDescriptionBuilder connectionFactory = hornetqServer.addChildResource(ConnectionFactoryDefinition.PATH);
        connectionFactory.getAttributeBuilder().setValueConverter((AttributeConverter)new DoubleToBigDecimalConverter(), new AttributeDefinition[]{CommonAttributes.RETRY_INTERVAL_MULTIPLIER});
        ResourceTransformationDescriptionBuilder pooledConnectionFactory = hornetqServer.addChildResource(PooledConnectionFactoryDefinition.PATH);
        pooledConnectionFactory.getAttributeBuilder().setValueConverter((AttributeConverter)new DoubleToBigDecimalConverter(), new AttributeDefinition[]{CommonAttributes.RETRY_INTERVAL_MULTIPLIER});
    }

    private static void buildTransformers2_0_0(ResourceTransformationDescriptionBuilder builder) {
    }

    private static void buildTransformers1_4_0(ResourceTransformationDescriptionBuilder builder) {
        ResourceTransformationDescriptionBuilder hornetqServer = builder.addChildResource(PathElement.pathElement((String)"hornetq-server"));
        MessagingTransformers.renameAttribute(hornetqServer, (AttributeDefinition)CommonAttributes.STATISTICS_ENABLED, (AttributeDefinition)CommonAttributes.MESSAGE_COUNTER_ENABLED);
        ResourceTransformationDescriptionBuilder bridge = hornetqServer.addChildResource(BridgeDefinition.PATH);
        MessagingTransformers.rejectDefinedAttributeWithDefaultValue(bridge, new AttributeDefinition[]{BridgeDefinition.RECONNECT_ATTEMPTS_ON_SAME_NODE, BridgeDefinition.INITIAL_CONNECT_ATTEMPTS});
        ResourceTransformationDescriptionBuilder clusterConnection = hornetqServer.addChildResource(ClusterConnectionDefinition.PATH);
        MessagingTransformers.rejectDefinedAttributeWithDefaultValue(clusterConnection, new AttributeDefinition[]{ClusterConnectionDefinition.INITIAL_CONNECT_ATTEMPTS});
        ResourceTransformationDescriptionBuilder addressSetting = hornetqServer.addChildResource(AddressSettingDefinition.PATH);
        MessagingTransformers.rejectDefinedAttributeWithDefaultValue(addressSetting, new AttributeDefinition[]{AddressSettingDefinition.EXPIRY_DELAY});
    }

    private static void buildTransformers1_3_0(ResourceTransformationDescriptionBuilder builder) {
        ResourceTransformationDescriptionBuilder hornetqServer = builder.addChildResource(PathElement.pathElement((String)"hornetq-server"));
        MessagingTransformers.rejectDefinedAttributeWithDefaultValue(hornetqServer, new AttributeDefinition[]{CommonAttributes.OVERRIDE_IN_VM_SECURITY});
        hornetqServer.rejectChildResource(HTTPAcceptorDefinition.PATH);
        hornetqServer.rejectChildResource(PathElement.pathElement((String)"http-connector"));
        ResourceTransformationDescriptionBuilder addressSetting = hornetqServer.addChildResource(AddressSettingDefinition.PATH);
        MessagingTransformers.rejectDefinedAttributeWithDefaultValue(addressSetting, new AttributeDefinition[]{AddressSettingDefinition.SLOW_CONSUMER_CHECK_PERIOD, AddressSettingDefinition.SLOW_CONSUMER_POLICY, AddressSettingDefinition.SLOW_CONSUMER_THRESHOLD});
    }

    private static void rejectDefinedAttributeWithDefaultValue(ResourceTransformationDescriptionBuilder builder, AttributeDefinition ... attrs) {
        ((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, attrs)).addRejectCheck(RejectAttributeChecker.DEFINED, attrs);
    }

    private static void renameAttribute(ResourceTransformationDescriptionBuilder builder, AttributeDefinition attribute, AttributeDefinition alias) {
        builder.getAttributeBuilder().addRename(attribute, alias.getName());
    }

    private static class DoubleToBigDecimalConverter
    extends AttributeConverter.DefaultAttributeConverter {
        private DoubleToBigDecimalConverter() {
        }

        protected void convertAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
            double value = attributeValue.asDouble(CommonAttributes.RETRY_INTERVAL_MULTIPLIER.getDefaultValue().asDouble());
            attributeValue.set(BigDecimal.valueOf(value));
        }
    }
}

