/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.jar.runtime;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ControlledProcessStateService;
import org.jboss.as.controller.LocalModelControllerClient;
import org.jboss.as.controller.ModelControllerClientFactory;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.DelegatingModelControllerClient;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.Main;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerService;
import org.jboss.as.server.SystemExiter;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.threads.AsyncFuture;
import org.wildfly.core.jar.runtime._private.BootableJarLogger;

final class Server {
    private static final String MODULE_ID_VFS = "org.jboss.vfs";
    private final PropertyChangeListener processStateListener;
    private final String[] cmdargs;
    private final Properties systemProps;
    private final Map<String, String> systemEnv;
    private final ModuleLoader moduleLoader;
    private ServiceContainer serviceContainer;
    private ControlledProcessState.State currentProcessState;
    private ModelControllerClient modelControllerClient;
    private ExecutorService executorService;
    private ProcessStateNotifier processStateNotifier;
    private final ShutdownHandler shutdownHandler;

    private Server(String[] cmdargs, Properties systemProps, Map<String, String> systemEnv, ModuleLoader moduleLoader, ShutdownHandler shutdownHandler) {
        this.cmdargs = cmdargs;
        this.systemProps = systemProps;
        this.systemEnv = systemEnv;
        this.moduleLoader = moduleLoader;
        this.shutdownHandler = shutdownHandler;
        this.processStateListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("currentState".equals(evt.getPropertyName())) {
                    ControlledProcessState.State newState = (ControlledProcessState.State)evt.getNewValue();
                    Server.this.establishModelControllerClient(newState, false);
                }
            }
        };
    }

    static Server newSever(String[] cmdargs, ModuleLoader moduleLoader, ShutdownHandler shutdownHandler) {
        Server.setupVfsModule(moduleLoader);
        Properties sysprops = Server.getSystemPropertiesPrivileged();
        Map<String, String> sysenv = Server.getSystemEnvironmentPrivileged();
        return new Server(cmdargs, sysprops, sysenv, moduleLoader, shutdownHandler);
    }

    private static void setupVfsModule(ModuleLoader moduleLoader) {
        Module vfsModule;
        try {
            vfsModule = moduleLoader.loadModule(MODULE_ID_VFS);
        }
        catch (ModuleLoadException mle) {
            throw BootableJarLogger.ROOT_LOGGER.moduleLoaderError(mle, MODULE_ID_VFS, moduleLoader);
        }
        Module.registerURLStreamHandlerFactoryModule((Module)vfsModule);
    }

    private static Map<String, String> getSystemEnvironmentPrivileged() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getenv();
        }
        return AccessController.doPrivileged(System::getenv);
    }

    private static Properties getSystemPropertiesPrivileged() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return System.getProperties();
        }
        return AccessController.doPrivileged(System::getProperties);
    }

    synchronized ModelControllerClient getModelControllerClient() {
        return this.modelControllerClient == null ? null : new DelegatingModelControllerClient(new DelegatingModelControllerClient.DelegateProvider(){

            public ModelControllerClient getDelegate() {
                return Server.this.getActiveModelControllerClient();
            }
        });
    }

    void start() throws Exception {
        Bootstrap bootstrap = null;
        try {
            long startTime = System.currentTimeMillis();
            SystemExiter.initialize((SystemExiter.Exiter)new SystemExiter.Exiter(){

                public void exit(int status) {
                    Server.this.exit();
                    Server.this.shutdownHandler.shutdown(status);
                }
            });
            ServerEnvironment serverEnvironment = Main.determineEnvironment((String[])this.cmdargs, (Properties)this.systemProps, this.systemEnv, (ServerEnvironment.LaunchType)ServerEnvironment.LaunchType.STANDALONE, (long)startTime).getServerEnvironment();
            if (serverEnvironment == null) {
                return;
            }
            bootstrap = Bootstrap.Factory.newInstance();
            Bootstrap.Configuration configuration = new Bootstrap.Configuration(serverEnvironment);
            configuration.setModuleLoader(this.moduleLoader);
            AsyncFuture future = bootstrap.startup(configuration, Collections.emptyList());
            this.serviceContainer = (ServiceContainer)future.get();
            this.executorService = Executors.newCachedThreadPool();
            ServiceController processStateNotifierValue = this.serviceContainer.getRequiredService(ControlledProcessStateService.SERVICE_NAME);
            this.processStateNotifier = (ProcessStateNotifier)processStateNotifierValue.getValue();
            this.processStateNotifier.addPropertyChangeListener(this.processStateListener);
            this.establishModelControllerClient(this.processStateNotifier.getCurrentState(), true);
        }
        catch (RuntimeException rte) {
            if (bootstrap != null) {
                bootstrap.failed();
            }
            throw rte;
        }
        catch (Exception ex) {
            if (bootstrap != null) {
                bootstrap.failed();
            }
            throw BootableJarLogger.ROOT_LOGGER.cannotStartServer(ex);
        }
    }

    private void exit() {
        if (this.serviceContainer != null) {
            try {
                this.serviceContainer.shutdown();
                this.serviceContainer.awaitTermination();
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (InterruptedException ite) {
                BootableJarLogger.ROOT_LOGGER.error(ite.getLocalizedMessage(), ite);
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                BootableJarLogger.ROOT_LOGGER.error(ex.getLocalizedMessage(), ex);
            }
        }
        if (this.processStateNotifier != null) {
            this.processStateNotifier.removePropertyChangeListener(this.processStateListener);
            this.processStateNotifier = null;
        }
        if (this.executorService != null) {
            try {
                this.executorService.shutdown();
                this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (InterruptedException ite) {
                BootableJarLogger.ROOT_LOGGER.error(ite.getLocalizedMessage(), ite);
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                BootableJarLogger.ROOT_LOGGER.error(ex.getLocalizedMessage(), ex);
            }
        }
        SystemExiter.initialize((SystemExiter.Exiter)SystemExiter.Exiter.DEFAULT);
    }

    private synchronized void establishModelControllerClient(ControlledProcessState.State state, boolean storeState) {
        LocalModelControllerClient newClient = null;
        if (state != ControlledProcessState.State.STOPPING && state != ControlledProcessState.State.STOPPED && this.serviceContainer != null) {
            ModelControllerClientFactory clientFactory;
            try {
                ServiceController clientFactorySvc = this.serviceContainer.getService(ServerService.JBOSS_SERVER_CLIENT_FACTORY);
                clientFactory = (ModelControllerClientFactory)clientFactorySvc.getValue();
            }
            catch (RuntimeException e) {
                clientFactory = null;
            }
            if (clientFactory != null) {
                newClient = clientFactory.createSuperUserClient((Executor)this.executorService, true);
            }
        }
        this.modelControllerClient = newClient;
        if (storeState || this.currentProcessState == null) {
            this.currentProcessState = state;
        }
    }

    private synchronized ModelControllerClient getActiveModelControllerClient() {
        switch (this.currentProcessState) {
            case STOPPING: {
                throw BootableJarLogger.ROOT_LOGGER.processIsStopping();
            }
            case STOPPED: {
                throw BootableJarLogger.ROOT_LOGGER.processIsStopped();
            }
            case STARTING: 
            case RUNNING: {
                if (this.modelControllerClient != null) break;
                this.establishModelControllerClient(this.currentProcessState, false);
                if (this.modelControllerClient != null) break;
                throw BootableJarLogger.ROOT_LOGGER.processIsReloading();
            }
        }
        return this.modelControllerClient;
    }

    static interface ShutdownHandler {
        public void shutdown(int var1);
    }
}

