/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.smallrye.metrics.SmallRyeMetricsLogging;
import io.smallrye.metrics.SmallRyeMetricsMessages;
import io.smallrye.metrics.elementdesc.MemberInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricType;

public class MemberToMetricMappings {
    private Map<MemberInfo, Set<MetricID>> counters = new HashMap<MemberInfo, Set<MetricID>>();
    private Map<MemberInfo, Set<MetricID>> concurrentGauges = new HashMap<MemberInfo, Set<MetricID>>();
    private Map<MemberInfo, Set<MetricID>> meters = new HashMap<MemberInfo, Set<MetricID>>();
    private Map<MemberInfo, Set<MetricID>> timers = new HashMap<MemberInfo, Set<MetricID>>();
    private Map<MemberInfo, Set<MetricID>> simpleTimers = new HashMap<MemberInfo, Set<MetricID>>();

    MemberToMetricMappings() {
    }

    public Set<MetricID> getCounters(MemberInfo member) {
        return this.counters.get(member);
    }

    public Set<MetricID> getConcurrentGauges(MemberInfo member) {
        return this.concurrentGauges.get(member);
    }

    public Set<MetricID> getMeters(MemberInfo member) {
        return this.meters.get(member);
    }

    public Set<MetricID> getTimers(MemberInfo member) {
        return this.timers.get(member);
    }

    public Set<MetricID> getSimpleTimers(MemberInfo member) {
        return this.simpleTimers.get(member);
    }

    public void addMetric(MemberInfo member, MetricID metricID, MetricType metricType) {
        switch (metricType) {
            case COUNTER: {
                this.counters.computeIfAbsent(member, id -> new HashSet()).add(metricID);
                break;
            }
            case CONCURRENT_GAUGE: {
                this.concurrentGauges.computeIfAbsent(member, id -> new HashSet()).add(metricID);
                break;
            }
            case METERED: {
                this.meters.computeIfAbsent(member, id -> new HashSet()).add(metricID);
                break;
            }
            case TIMER: {
                this.timers.computeIfAbsent(member, id -> new HashSet()).add(metricID);
                break;
            }
            case SIMPLE_TIMER: {
                this.simpleTimers.computeIfAbsent(member, id -> new HashSet()).add(metricID);
                break;
            }
            default: {
                throw SmallRyeMetricsMessages.msg.unknownMetricType();
            }
        }
        SmallRyeMetricsLogging.log.matchingMemberToMetric(member, metricID, metricType);
    }

    public void removeMappingsFor(MemberInfo member, MetricID metricID) {
        this.removeMapping(this.counters, member, metricID);
        this.removeMapping(this.concurrentGauges, member, metricID);
        this.removeMapping(this.meters, member, metricID);
        this.removeMapping(this.timers, member, metricID);
        this.removeMapping(this.simpleTimers, member, metricID);
    }

    private void removeMapping(Map<MemberInfo, Set<MetricID>> map, MemberInfo member, MetricID metricID) {
        if (map.containsKey(member)) {
            map.get(member).remove(metricID);
        }
    }
}

