/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.jgroups.subsystem.ProtocolConfigurationServiceConfigurator;
import org.jboss.as.clustering.jgroups.subsystem.SocketProtocolResourceDefinition;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.network.ClientMapping;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jgroups.protocols.FD_SOCK;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SimpleSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class SocketProtocolConfigurationServiceConfigurator
extends ProtocolConfigurationServiceConfigurator<FD_SOCK> {
    private volatile SupplierDependency<SocketBinding> binding;
    private volatile SupplierDependency<SocketBinding> clientBinding;

    public SocketProtocolConfigurationServiceConfigurator(PathAddress address) {
        super(address);
    }

    @Override
    public <T> ServiceBuilder<T> register(ServiceBuilder<T> builder) {
        return super.register(new CompositeDependency(new Dependency[]{this.binding, this.clientBinding}).register(builder));
    }

    @Override
    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.binding = SocketProtocolConfigurationServiceConfigurator.createDependency(context, model, SocketProtocolResourceDefinition.Attribute.SOCKET_BINDING);
        this.clientBinding = SocketProtocolConfigurationServiceConfigurator.createDependency(context, model, SocketProtocolResourceDefinition.Attribute.CLIENT_SOCKET_BINDING);
        return super.configure(context, model);
    }

    private static SupplierDependency<SocketBinding> createDependency(OperationContext context, ModelNode model, Attribute attribute) throws OperationFailedException {
        String bindingName = attribute.resolveModelAttribute((ExpressionResolver)context, model).asStringOrNull();
        return bindingName != null ? new ServiceSupplierDependency(CommonUnaryRequirement.SOCKET_BINDING.getServiceName(context, bindingName)) : new SimpleSupplierDependency(null);
    }

    public Map<String, SocketBinding> getSocketBindings() {
        HashMap<String, SocketBinding> bindings = new HashMap<String, SocketBinding>();
        bindings.put("jgroups.fd_sock.srv_sock", (SocketBinding)this.binding.get());
        bindings.put("jgroups.fd.ping_sock", (SocketBinding)this.clientBinding.get());
        return bindings;
    }

    @Override
    public void accept(FD_SOCK protocol) {
        SocketBinding clientBinding;
        SocketBinding binding = (SocketBinding)this.binding.get();
        if (binding != null) {
            protocol.setValue("bind_addr", (Object)binding.getAddress());
            protocol.setValue("start_port", (Object)binding.getPort());
            List clientMappings = binding.getClientMappings();
            if (!clientMappings.isEmpty()) {
                ClientMapping mapping = (ClientMapping)clientMappings.get(0);
                try {
                    this.setValue(protocol, "external_addr", InetAddress.getByName(mapping.getDestinationAddress()));
                    this.setValue(protocol, "external_port", mapping.getDestinationPort());
                }
                catch (UnknownHostException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
        if ((clientBinding = (SocketBinding)this.clientBinding.get()) != null) {
            InetSocketAddress socketAddress = clientBinding.getSocketAddress();
            protocol.setValue("client_bind_port", (Object)socketAddress.getPort());
        }
    }
}

