/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.http.oidc;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.wildfly.common.iteration.ByteIterator;
import org.wildfly.security.http.oidc.ClientSecretCredentialsProvider;
import org.wildfly.security.http.oidc.ElytronMessages;
import org.wildfly.security.http.oidc.Oidc;
import org.wildfly.security.http.oidc.OidcClientConfiguration;

public class ClientIdAndSecretCredentialsProvider
implements ClientSecretCredentialsProvider {
    private String clientSecretString;
    private SecretKey clientSecret;

    @Override
    public String getId() {
        return Oidc.ClientCredentialsProviderType.SECRET.getValue();
    }

    @Override
    public void init(OidcClientConfiguration oidcClientConfiguration, Object credentialsConfig) {
        this.clientSecretString = (String)credentialsConfig;
        this.clientSecret = credentialsConfig == null ? null : new SecretKeySpec(this.clientSecretString.getBytes(StandardCharsets.UTF_8), Oidc.getJavaAlgorithm("HS256"));
    }

    @Override
    public void setClientCredentials(OidcClientConfiguration oidcClientConfiguration, Map<String, String> requestHeaders, Map<String, String> formParams) {
        String clientId = oidcClientConfiguration.getResourceName();
        if (!oidcClientConfiguration.isPublicClient()) {
            if (this.clientSecretString != null) {
                String authorization = ClientIdAndSecretCredentialsProvider.createBasicHeader(clientId, this.clientSecretString);
                requestHeaders.put("authorization", authorization);
            } else {
                ElytronMessages.log.noClientSecretConfigured(clientId);
            }
        } else {
            formParams.put("client_id", clientId);
        }
    }

    @Override
    public SecretKey getClientSecret() {
        return this.clientSecret;
    }

    private static String createBasicHeader(String username, String password) {
        StringBuffer buf = new StringBuffer(username);
        buf.append(':').append(password);
        return "Basic " + ByteIterator.ofBytes(buf.toString().getBytes(StandardCharsets.UTF_8)).base64Encode().drainToString();
    }
}

