/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers;

import io.smallrye.mutiny.Multi;
import io.smallrye.reactive.converters.ReactiveTypeConverter;
import io.smallrye.reactive.converters.Registry;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.providers.AbstractMediator;
import io.smallrye.reactive.messaging.providers.helpers.MultiUtils;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.providers.i18n.ProviderMessages;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;

public class StreamTransformerMediator
extends AbstractMediator {
    Function<Multi<? extends Message<?>>, Multi<? extends Message<?>>> function;
    private Multi<? extends Message<?>> publisher;

    public StreamTransformerMediator(MediatorConfiguration configuration) {
        super(configuration);
        if (configuration.consumption() == MediatorConfiguration.Consumption.STREAM_OF_MESSAGE && configuration.production() == MediatorConfiguration.Production.STREAM_OF_PAYLOAD) {
            throw ProviderExceptions.ex.definitionProducePayloadStreamAndConsumeMessageStream(configuration.methodAsString());
        }
        if (configuration.consumption() == MediatorConfiguration.Consumption.STREAM_OF_PAYLOAD && configuration.production() == MediatorConfiguration.Production.STREAM_OF_MESSAGE) {
            throw ProviderExceptions.ex.definitionProduceMessageStreamAndConsumePayloadStream(configuration.methodAsString());
        }
    }

    @Override
    public void connectToUpstream(Multi<? extends Message<?>> publisher) {
        Objects.requireNonNull(this.function);
        Multi<? extends Message<?>> converted = this.convert(publisher);
        this.publisher = this.decorate(this.function.apply(converted));
    }

    @Override
    public Multi<? extends Message<?>> getStream() {
        Objects.requireNonNull(this.publisher);
        return this.publisher;
    }

    @Override
    public boolean isConnected() {
        return this.publisher != null;
    }

    @Override
    public void initialize(Object bean) {
        super.initialize(bean);
        switch (this.configuration.consumption()) {
            case STREAM_OF_MESSAGE: {
                if (this.configuration.usesBuilderTypes()) {
                    this.processMethodConsumingAPublisherBuilderOfMessages();
                    break;
                }
                this.processMethodConsumingAPublisherOfMessages();
                break;
            }
            case STREAM_OF_PAYLOAD: {
                if (this.configuration.usesBuilderTypes()) {
                    this.processMethodConsumingAPublisherBuilderOfPayload();
                    break;
                }
                this.processMethodConsumingAPublisherOfPayload();
                break;
            }
            default: {
                throw ProviderExceptions.ex.illegalArgumentForUnexpectedConsumption(this.configuration.consumption());
            }
        }
        assert (this.function != null);
    }

    private void processMethodConsumingAPublisherBuilderOfMessages() {
        this.function = upstream -> {
            Multi<? extends Message<?>> multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration);
            PublisherBuilder argument = ReactiveStreams.fromPublisher(multi);
            PublisherBuilder result = (PublisherBuilder)this.invoke(argument);
            Objects.requireNonNull(result, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            return Multi.createFrom().publisher(result.buildRs());
        };
    }

    private void processMethodConsumingAPublisherOfMessages() {
        this.function = upstream -> {
            Multi<? extends Message<?>> multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration);
            Publisher<? extends Message<?>> argument = this.convertToDesiredPublisherType(multi);
            Publisher result = (Publisher)this.invoke(argument);
            Objects.requireNonNull(result, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            return Multi.createFrom().publisher(result);
        };
    }

    private <T> Publisher<T> convertToDesiredPublisherType(Multi<T> multi) {
        Class parameterType = this.configuration.getParameterTypes()[0];
        Optional converter = Registry.lookup((Class)parameterType);
        Publisher argument = multi;
        if (converter.isPresent()) {
            argument = (Publisher)((ReactiveTypeConverter)converter.get()).fromPublisher(multi);
        }
        return argument;
    }

    private void processMethodConsumingAPublisherBuilderOfPayload() {
        this.function = upstream -> {
            Multi multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transform(Message::getPayload);
            PublisherBuilder argument = ReactiveStreams.fromPublisher((Publisher)multi);
            PublisherBuilder result = (PublisherBuilder)this.invoke(argument);
            Objects.requireNonNull(result, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            return Multi.createFrom().publisher(result.buildRs()).onItem().transform(Message::of);
        };
    }

    private void processMethodConsumingAPublisherOfPayload() {
        this.function = upstream -> {
            Multi multi = MultiUtils.handlePreProcessingAcknowledgement(upstream, this.configuration).onItem().transform(Message::getPayload);
            Publisher argument = this.convertToDesiredPublisherType(multi);
            Publisher result = (Publisher)this.invoke(argument);
            Objects.requireNonNull(result, ProviderMessages.msg.methodReturnedNull(this.configuration.methodAsString()));
            return Multi.createFrom().publisher(result).onItem().transform(Message::of);
        };
    }
}

