/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.LogRecord;
import org.apache.log4j.Appender;
import org.apache.log4j.Appenders;
import org.apache.log4j.JBossFilterWrapper;
import org.apache.log4j.JBossLogManagerFacade;
import org.apache.log4j.spi.LoggingEvent;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.Logger;

final class JBossAppenderHandler
extends ExtHandler {
    private final Logger logger;

    protected JBossAppenderHandler(Logger logger) {
        this.logger = logger;
    }

    protected void doPublish(ExtLogRecord record) {
        LoggingEvent event = new LoggingEvent(record, JBossLogManagerFacade.getLogger(this.logger));
        CopyOnWriteArrayList<Appender> appenders = Appenders.getAppenderList(this.logger);
        for (Appender appender : appenders) {
            if (!new JBossFilterWrapper(appender.getFilter(), true).isLoggable((LogRecord)record)) continue;
            appender.doAppend(event);
        }
    }

    public void flush() {
    }

    public void close() throws SecurityException {
        JBossAppenderHandler.checkAccess((ExtHandler)this);
        Appenders.closeAppenders(this.logger);
    }

    public int hashCode() {
        int prime = 31;
        int hash = 17;
        hash = 31 * hash + (this.logger == null ? 0 : this.logger.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof JBossAppenderHandler)) {
            return false;
        }
        JBossAppenderHandler other = (JBossAppenderHandler)((Object)obj);
        return this.logger == null ? other.logger == null : this.logger.equals(other.logger);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass() + "{" + this.logger.getName() + "}";
    }
}

