/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.jcr.security;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.jcr.Credentials;
import org.silverpeas.core.jcr.security.SilverpeasJCRLoginModule;
import org.silverpeas.core.jcr.security.SilverpeasSimpleJCRLoginModule;
import org.silverpeas.core.jcr.security.SilverpeasTokenJCRLoginModule;
import org.silverpeas.kernel.SilverpeasRuntimeException;

public class LoginModuleRegistry {
    private static final LoginModuleRegistry instance = new LoginModuleRegistry();
    private final Map<Class<? extends Credentials>, List<Supplier<SilverpeasJCRLoginModule>>> registry = new HashMap<Class<? extends Credentials>, List<Supplier<SilverpeasJCRLoginModule>>>();

    private LoginModuleRegistry() {
        SilverpeasSimpleJCRLoginModule.SUPPORTED_CREDENTIALS.forEach(c -> this.addLoginModule((Class<? extends Credentials>)c, (Class<? extends SilverpeasJCRLoginModule>)SilverpeasSimpleJCRLoginModule.class));
        SilverpeasTokenJCRLoginModule.SUPPORTED_CREDENTIALS.forEach(c -> this.addLoginModule((Class<? extends Credentials>)c, (Class<? extends SilverpeasJCRLoginModule>)SilverpeasTokenJCRLoginModule.class));
    }

    public static LoginModuleRegistry getInstance() {
        return instance;
    }

    public void addLoginModule(Class<? extends Credentials> credentialsType, Class<? extends SilverpeasJCRLoginModule> module) {
        this.registry.computeIfAbsent(credentialsType, k -> new ArrayList()).add(() -> this.spawn(module));
    }

    public Set<SilverpeasJCRLoginModule> getLoginModule(Class<? extends Credentials> credentialsType) {
        return this.registry.getOrDefault(credentialsType, Collections.emptyList()).stream().map(Supplier::get).collect(Collectors.toSet());
    }

    private SilverpeasJCRLoginModule spawn(Class<? extends SilverpeasJCRLoginModule> clazz) {
        PrivilegedExceptionAction<SilverpeasJCRLoginModule> newLoginModule = () -> {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            MethodHandles.Lookup privateLookup = MethodHandles.privateLookupIn(clazz, lookup);
            MethodType constructorType = MethodType.methodType(Void.TYPE);
            MethodHandle constructor = privateLookup.findConstructor(clazz, constructorType);
            try {
                return constructor.invoke();
            }
            catch (Throwable e) {
                throw new SilverpeasRuntimeException(e);
            }
        };
        try {
            return AccessController.doPrivileged(newLoginModule);
        }
        catch (PrivilegedActionException e) {
            throw new SilverpeasRuntimeException((Throwable)e);
        }
    }
}

