/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.viewer;

import java.util.Optional;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.webapi.viewer.ResourceView;
import org.silverpeas.core.webapi.viewer.ResourceViewProviderRegistry;
import org.silverpeas.kernel.util.StringUtil;

public interface ResourceViewProvider {
    public static ResourceView getAuthorizedResourceView(String resourceId, String resourceType, String language) {
        if (StringUtil.isNotDefined((String)resourceId)) {
            throw new WebApplicationException("resourceId is missing", Response.Status.BAD_REQUEST);
        }
        ResourceView resource = ResourceViewProviderRegistry.get().getByResourceType(resourceType).stream().flatMap(p -> p.getByIdAndLanguage(resourceId, language).stream()).findFirst().orElse(null);
        if (resource == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!resource.canBeAccessedBy(User.getCurrentRequester())) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
        return resource;
    }

    public Optional<ResourceView> getByIdAndLanguage(String var1, String var2);

    public String relatedToService();
}

