/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.profile;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.silverpeas.core.admin.user.constant.UserAccessLevel;
import org.silverpeas.core.admin.user.constant.UserState;
import org.silverpeas.core.admin.user.model.Group;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.admin.user.model.UserFull;
import org.silverpeas.core.annotation.WebService;
import org.silverpeas.core.chat.ChatUser;
import org.silverpeas.core.socialnetwork.relationship.RelationShip;
import org.silverpeas.core.socialnetwork.relationship.RelationShipService;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.ListSlice;
import org.silverpeas.core.util.SilverpeasList;
import org.silverpeas.core.web.rs.RESTWebService;
import org.silverpeas.core.web.rs.UserPrivilegeValidation;
import org.silverpeas.core.web.rs.annotation.Authorized;
import org.silverpeas.core.webapi.profile.ChatUserProfileEntity;
import org.silverpeas.core.webapi.profile.UserProfileEntity;
import org.silverpeas.core.webapi.profile.UserProfileExtendedEntity;
import org.silverpeas.core.webapi.profile.UserProfileService;
import org.silverpeas.core.webapi.profile.UserProfilesSearchCriteriaBuilder;
import org.silverpeas.kernel.util.StringUtil;

@WebService
@Path(value="profile/users")
@Authorized
public class UserProfileResource
extends RESTWebService {
    public static final String RESPONSE_HEADER_USERSIZE = "X-Silverpeas-UserSize";
    public static final String QUERY_ALL_GROUPS = "all";
    @Inject
    private UserProfileService profileService;
    @Inject
    private RelationShipService relationShipService;

    @GET
    @Path(value="token")
    @Produces(value={"application/json"})
    public UserProfileEntity checkUserToken() {
        try {
            return UserProfileEntity.fromUser(this.getUser()).withAsUri(this.getUri().getRequestUri());
        }
        catch (WebApplicationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex, Response.Status.SERVICE_UNAVAILABLE);
        }
    }

    @GET
    @Produces(value={"application/json"})
    public Response getUsers(@QueryParam(value="id") Set<String> userIds, @QueryParam(value="group") List<String> groupIds, @QueryParam(value="name") String name, @QueryParam(value="page") String page, @QueryParam(value="domain") List<String> domainIds, @QueryParam(value="accessLevel") Set<UserAccessLevel> accessLevels, @QueryParam(value="userStatesToExclude") Set<UserState> userStatesToExclude, @QueryParam(value="includeRemoved") boolean includeRemovedUsers) {
        List<String> effectiveDomainIds = new ArrayList<String>(domainIds);
        if (CollectionUtil.isNotEmpty(domainIds) && domainIds.size() == 1 && domainIds.get(0).equals("-1")) {
            effectiveDomainIds.clear();
        }
        if (!groupIds.isEmpty() && !groupIds.contains(QUERY_ALL_GROUPS)) {
            List<Group> groups = this.profileService.getGroupsAccessibleToUser(groupIds, UserDetail.from((User)this.getUser()));
            for (Group group : groups) {
                if (StringUtil.isDefined((String)group.getDomainId())) {
                    effectiveDomainIds.add(group.getDomainId());
                    continue;
                }
                effectiveDomainIds.clear();
                break;
            }
        }
        if (this.getUser().isDomainRestricted()) {
            effectiveDomainIds = Collections.singletonList(this.getUser().getDomainId());
        }
        UserProfilesSearchCriteriaBuilder criteriaBuilder = UserProfilesSearchCriteriaBuilder.aSearchCriteria().withDomainIds(effectiveDomainIds.toArray(new String[0])).withGroupIds(groupIds.toArray(new String[0])).withName(name).withPaginationPage(this.fromPage(page));
        if (CollectionUtil.isNotEmpty(userIds)) {
            criteriaBuilder.withUserIds(userIds.toArray(new String[0]));
        }
        if (CollectionUtil.isNotEmpty(accessLevels)) {
            criteriaBuilder.withAccessLevels(accessLevels.toArray(new UserAccessLevel[0]));
        }
        this.setCriterionOnUserStates(criteriaBuilder, userStatesToExclude, includeRemovedUsers);
        SilverpeasList users = this.getOrganisationController().searchUsers(criteriaBuilder.build());
        return Response.ok((Object)this.asWebEntity((List<? extends UserDetail>)users, UserProfileResource.locatedAt(this.getUri().getAbsolutePath()))).header(RESPONSE_HEADER_USERSIZE, (Object)users.originalListSize()).header("X-Silverpeas-Size", (Object)users.originalListSize()).build();
    }

    private void setCriterionOnUserStates(UserProfilesSearchCriteriaBuilder criteriaBuilder, Set<UserState> userStatesToExclude, boolean includeRemovedUsers) {
        if (CollectionUtil.isNotEmpty(userStatesToExclude)) {
            HashSet<UserState> statesToExclude = new HashSet<UserState>(userStatesToExclude);
            criteriaBuilder.withUserStatesToExclude(statesToExclude.toArray(new UserState[0]));
        }
        if (includeRemovedUsers) {
            criteriaBuilder.includeAlsoRemovedUsers();
        }
    }

    @GET
    @Path(value="{userId}")
    @Produces(value={"application/json"})
    public UserProfileEntity getUser(@PathParam(value="userId") String userId, @QueryParam(value="extended") boolean extended) {
        URI uri = UserProfileResource.identifiedBy(this.getUri().getAbsolutePath());
        if (extended) {
            return this.asWebEntity(this.getUserFullMatching(userId), uri);
        }
        return this.asWebEntity(ChatUser.fromUser((User)this.getUserDetailMatching(userId)), uri);
    }

    @GET
    @Path(value="application/{instanceId}")
    public Response getApplicationUsers(@PathParam(value="instanceId") String instanceId, @QueryParam(value="group") String groupId, @QueryParam(value="roles") String roles, @QueryParam(value="matchingAllRoles") boolean matchingAllRoles, @QueryParam(value="resource") String resource, @QueryParam(value="name") String name, @QueryParam(value="page") String page, @QueryParam(value="userStatesToExclude") Set<UserState> userStatesToExclude, @QueryParam(value="includeRemoved") boolean includeRemovedUsers) {
        Group group;
        String[] roleNames = StringUtil.isDefined((String)roles) ? roles.split(",") : null;
        List<Object> domainIds = new ArrayList();
        if (StringUtil.isDefined((String)groupId) && !QUERY_ALL_GROUPS.equals(groupId) && StringUtil.isDefined((String)(group = this.profileService.getGroupAccessibleToUser(groupId, UserDetail.from((User)this.getUser()))).getDomainId())) {
            domainIds.add(group.getDomainId());
        }
        if (this.getUser().isDomainRestricted()) {
            domainIds = Collections.singletonList(this.getUser().getDomainId());
        }
        UserProfilesSearchCriteriaBuilder criteriaBuilder = UserProfilesSearchCriteriaBuilder.aSearchCriteria().withDomainIds(domainIds.toArray(new String[0])).withComponentInstanceId(instanceId).withRoles(roleNames, matchingAllRoles).withResourceId(resource).withGroupIds(groupId).withName(name).withPaginationPage(this.fromPage(page));
        this.setCriterionOnUserStates(criteriaBuilder, userStatesToExclude, includeRemovedUsers);
        SilverpeasList users = this.getOrganisationController().searchUsers(criteriaBuilder.build());
        URI usersUri = this.getUri().getBaseUriBuilder().path("profile/users").build(new Object[0]);
        return Response.ok((Object)this.asWebEntity((List<? extends UserDetail>)users, UserProfileResource.locatedAt(usersUri))).header(RESPONSE_HEADER_USERSIZE, (Object)users.originalListSize()).header("X-Silverpeas-Size", (Object)users.originalListSize()).build();
    }

    @GET
    @Path(value="{userId}/contacts")
    @Produces(value={"application/json"})
    public Response getUserContacts(@PathParam(value="userId") String userId, @QueryParam(value="instance") String instanceId, @QueryParam(value="roles") String roles, @QueryParam(value="matchingAllRoles") boolean matchingAllRoles, @QueryParam(value="resource") String resource, @QueryParam(value="name") String name, @QueryParam(value="page") String page, @QueryParam(value="domain") String domain, @QueryParam(value="userStatesToExclude") Set<UserState> userStatesToExclude, @QueryParam(value="includeRemoved") boolean includeRemovedUsers) {
        ListSlice contacts;
        String domainId = "-1".equals(domain) ? null : domain;
        User theUser = this.getUserDetailMatching(userId);
        String[] roleNames = StringUtil.isDefined((String)roles) ? roles.split(",") : null;
        String[] contactIds = this.getContactIds(theUser.getId());
        if (contactIds.length > 0) {
            UserProfilesSearchCriteriaBuilder criteriaBuilder = UserProfilesSearchCriteriaBuilder.aSearchCriteria().withComponentInstanceId(instanceId).withDomainIds(domainId).withRoles(roleNames, matchingAllRoles).withResourceId(resource).withUserIds(contactIds).withName(name).withPaginationPage(this.fromPage(page));
            this.setCriterionOnUserStates(criteriaBuilder, userStatesToExclude, includeRemovedUsers);
            contacts = this.getOrganisationController().searchUsers(criteriaBuilder.build());
        } else {
            contacts = new ListSlice(0, 0, 0L);
        }
        URI usersUri = this.getUri().getBaseUriBuilder().path("profile/users").build(new Object[0]);
        return Response.ok((Object)this.asWebEntity((List<? extends UserDetail>)contacts, UserProfileResource.locatedAt(usersUri))).header(RESPONSE_HEADER_USERSIZE, (Object)contacts.originalListSize()).header("X-Silverpeas-Size", (Object)contacts.originalListSize()).build();
    }

    protected String getResourceBasePath() {
        return "profile/users";
    }

    public String getComponentId() {
        return null;
    }

    protected static URI locatedAt(URI uri) {
        return uri;
    }

    protected static URI identifiedBy(URI uri) {
        return uri;
    }

    private UserProfileEntity[] asWebEntity(List<? extends UserDetail> allUsers, URI baseUri) {
        return UserProfileEntity.fromUsers(allUsers, baseUri);
    }

    private UserProfileExtendedEntity asWebEntity(UserFull user, URI userUri) {
        return UserProfileExtendedEntity.fromUser(user).withAsUri(userUri);
    }

    private UserProfileEntity asWebEntity(ChatUser user, URI userUri) {
        return ChatUserProfileEntity.fromUser(user).withAsUri(userUri);
    }

    private UserDetail getUserDetailById(String userId) {
        UserDetail theUser = UserDetail.getById((String)userId);
        this.checkUser(userId, theUser);
        return theUser;
    }

    private UserFull getUserFullById(String userId) {
        UserFull theUser = UserFull.getById((String)userId);
        this.checkUser(userId, (UserDetail)theUser);
        return theUser;
    }

    private void checkUser(String userId, UserDetail theUser) {
        if (theUser == null) {
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        if (!theUser.isAccessAdmin() && this.getUser().isDomainRestricted() && !theUser.getDomainId().equals(this.getUser().getDomainId())) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "The user with id {0} isn''t authorized to access the profile of user with id {1}", new Object[]{theUser.getId(), userId});
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }

    private String[] getContactIds(String userId) {
        int myId = Integer.parseInt(userId);
        List relationShips = this.relationShipService.getAllMyRelationShips(myId);
        String[] userIds = new String[relationShips.size()];
        for (int i = 0; i < relationShips.size(); ++i) {
            RelationShip relationShip = (RelationShip)relationShips.get(i);
            userIds[i] = relationShip.getUser1Id() != myId ? String.valueOf(relationShip.getUser1Id()) : String.valueOf(relationShip.getUser2Id());
        }
        return userIds;
    }

    private User getUserDetailMatching(String identifier) {
        if (this.isCurrentUser(identifier)) {
            return this.getUser();
        }
        return this.getUserDetailById(identifier);
    }

    private UserFull getUserFullMatching(String identifier) {
        if (this.isCurrentUser(identifier)) {
            return this.getUserFullById(this.getUser().getId());
        }
        return this.getUserFullById(identifier);
    }

    private boolean isCurrentUser(String identifier) {
        return "me".equals(identifier) || this.getUser().getId().equals(identifier);
    }

    public void validateUserAuthorization(UserPrivilegeValidation validation) {
        User currentUser = this.getUser();
        if (currentUser.isAccessGuest()) {
            throw new WebApplicationException(Response.Status.FORBIDDEN);
        }
    }
}

