/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.pdc;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.silverpeas.core.pdc.pdc.model.ClassifyPosition;
import org.silverpeas.core.pdc.pdc.model.PdcClassification;
import org.silverpeas.core.pdc.pdc.model.PdcPosition;
import org.silverpeas.core.pdc.thesaurus.model.ThesaurusException;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.core.webapi.pdc.PdcPositionEntity;
import org.silverpeas.core.webapi.pdc.UserThesaurusHolder;
import org.silverpeas.kernel.util.StringUtil;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PdcClassificationEntity
implements WebEntity {
    private static final long serialVersionUID = -2217575091640675000L;
    @XmlElement(defaultValue="")
    private URI uri;
    @XmlElement
    private List<PdcPositionEntity> positions = new ArrayList<PdcPositionEntity>();
    @XmlElement
    private boolean modifiable = true;

    public static PdcClassificationEntity undefinedClassification() {
        return new PdcClassificationEntity();
    }

    public static PdcClassificationEntity aPdcClassificationEntity(List<ClassifyPosition> fromPositions, String inLanguage, URI atURI) {
        PdcClassificationEntity entity = new PdcClassificationEntity(atURI);
        entity.setClassificationPositions(PdcClassificationEntity.fromClassifyPositions(fromPositions, inLanguage, atURI));
        return entity;
    }

    public static PdcClassificationEntity aPdcClassificationEntity(PdcClassification classification, String inLanguage, URI atURI) {
        PdcClassificationEntity entity = new PdcClassificationEntity(atURI);
        entity.setClassificationPositions(PdcClassificationEntity.fromPdcPositions(classification.getPositions(), inLanguage, atURI));
        entity.setModifiable(classification.isModifiable());
        return entity;
    }

    public static PdcClassificationEntity fromJSON(String classification) {
        return (PdcClassificationEntity)JSONCodec.decode((String)classification, PdcClassificationEntity.class);
    }

    public String toJSON() {
        return JSONCodec.encode((Object)this);
    }

    public static String inLanguage(String language) {
        return language;
    }

    public static URI atURI(URI uri) {
        return uri;
    }

    public static List<ClassifyPosition> fromPositions(List<ClassifyPosition> positions) {
        return positions;
    }

    public static PdcClassification fromPdcClassification(PdcClassification classification) {
        return classification;
    }

    @XmlTransient
    public boolean isUndefined() {
        return this.getClassificationPositions().isEmpty();
    }

    public URI getURI() {
        return this.uri;
    }

    public PdcClassificationEntity withSynonymsFrom(UserThesaurusHolder userThesaurus) throws ThesaurusException {
        for (PdcPositionEntity pdcPositionEntity : this.positions) {
            pdcPositionEntity.setSynonymsFrom(userThesaurus);
        }
        return this;
    }

    @XmlTransient
    public List<PdcPositionEntity> getClassificationPositions() {
        return this.positions;
    }

    @XmlTransient
    public List<PdcPosition> getPdcPositions() {
        ArrayList<PdcPosition> pdcPositions = new ArrayList<PdcPosition>(this.positions.size());
        for (PdcPositionEntity position : this.positions) {
            pdcPositions.add(position.toPdcPosition());
        }
        return pdcPositions;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PdcClassificationEntity other = (PdcClassificationEntity)obj;
        if (!(this.uri == other.uri || this.uri != null && this.uri.equals(other.uri))) {
            return false;
        }
        return this.positions == other.positions || this.positions != null && this.positions.equals(other.positions);
    }

    public int hashCode() {
        int hash = 5;
        hash = 59 * hash + (this.uri != null ? this.uri.hashCode() : 0);
        hash = 59 * hash + (this.positions != null ? this.positions.hashCode() : 0);
        return hash;
    }

    public String toString() {
        StringBuilder positionArray = new StringBuilder("[");
        for (PdcPositionEntity pdcPositionEntity : this.positions) {
            positionArray.append(pdcPositionEntity.toString()).append(", ");
        }
        if (positionArray.length() > 1) {
            positionArray.replace(positionArray.length() - 2, positionArray.length(), "]");
        } else {
            positionArray.append("]");
        }
        return "PdcClassificationEntity{uri=" + String.valueOf(this.uri) + ", positions=" + positionArray.toString() + "}";
    }

    private static List<PdcPositionEntity> fromClassifyPositions(List<ClassifyPosition> positions, String inLanguage, URI atBaseURI) {
        TreeSet<PdcPositionEntity> positionEntities = new TreeSet<PdcPositionEntity>(new PositionComparator());
        for (ClassifyPosition position : positions) {
            positionEntities.add(PdcPositionEntity.fromClassifyPosition(position, inLanguage, atBaseURI));
        }
        return new ArrayList<PdcPositionEntity>(positionEntities);
    }

    private static List<PdcPositionEntity> fromPdcPositions(Collection<PdcPosition> positions, String inLanguage, URI atBaseURI) {
        TreeSet<PdcPositionEntity> positionEntities = new TreeSet<PdcPositionEntity>(new PositionComparator());
        for (PdcPosition position : positions) {
            positionEntities.add(PdcPositionEntity.fromPdcPosition(position, inLanguage, atBaseURI));
        }
        return new ArrayList<PdcPositionEntity>(positionEntities);
    }

    private PdcClassificationEntity() {
    }

    private PdcClassificationEntity(URI uri) {
        this.uri = uri;
    }

    public void setClassificationPositions(List<PdcPositionEntity> positions) {
        this.positions.clear();
        this.positions.addAll(positions);
    }

    protected void setModifiable(boolean modifiable) {
        this.modifiable = modifiable;
    }

    private static class PositionComparator
    implements Comparator<PdcPositionEntity> {
        private PositionComparator() {
        }

        private static boolean isIdDefined(PdcPositionEntity position) {
            return StringUtil.isDefined((String)position.getId()) && !position.getId().equals("-1");
        }

        @Override
        public int compare(PdcPositionEntity t, PdcPositionEntity t1) {
            if (PositionComparator.isIdDefined(t) && PositionComparator.isIdDefined(t1)) {
                return t.getId().compareTo(t1.getId());
            }
            return t.hashCode() - t1.hashCode();
        }
    }
}

