/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.webapi.attachment;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.contribution.attachment.AttachmentException;
import org.silverpeas.core.contribution.attachment.model.SimpleDocument;
import org.silverpeas.core.util.Charsets;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.rs.WebEntity;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;

@XmlRootElement
public class AttachmentEntity
implements WebEntity {
    private static final long serialVersionUID = 6578990825699318566L;
    @XmlElement(required=true)
    private String id;
    @XmlElement(required=true)
    private String instanceId;
    @XmlElement(required=true)
    private String logicalName;
    @XmlElement(defaultValue="")
    private String description;
    @XmlElement(defaultValue="")
    private String type;
    @XmlElement(defaultValue="0")
    private long creationDate;
    @XmlElement(defaultValue="0")
    private long size;
    @XmlElement(defaultValue="")
    private String author;
    @XmlElement(defaultValue="")
    private String title;
    @XmlElement(required=true)
    private URI uri;
    @XmlElement(required=true)
    private String icon;
    @XmlElement(required=true)
    private String permalink;
    @XmlElement(required=false)
    private URI sharedUri;

    public static AttachmentEntity fromAttachment(SimpleDocument detail) {
        AttachmentEntity entity = new AttachmentEntity();
        try {
            entity.uri = new URI(URLUtil.getSimpleURL((int)4, (String)detail.getId()));
        }
        catch (URISyntaxException e) {
            throw new AttachmentException("Couldn't build the URI to the attachment", (Throwable)e);
        }
        entity.id = detail.getId();
        entity.instanceId = detail.getInstanceId();
        entity.logicalName = detail.getFilename();
        entity.description = detail.getDescription();
        entity.size = detail.getSize();
        entity.creationDate = detail.getCreationDate().getTime();
        entity.author = detail.getCreatedBy();
        entity.title = detail.getTitle();
        entity.type = detail.getContentType();
        entity.icon = detail.getDisplayIcon();
        entity.permalink = URLUtil.getSimpleURL((int)4, (String)detail.getId());
        return entity;
    }

    public AttachmentEntity withURI(URI uri) {
        this.uri = uri;
        return this;
    }

    public URI getURI() {
        return this.uri;
    }

    public void withSharedUri(String baseURI, String token) {
        URI theUri;
        try {
            theUri = UriBuilder.fromUri((String)baseURI).path("sharing/attachments").path(this.instanceId).path(token).path(this.id).path(URLEncoder.encode(this.logicalName, Charsets.UTF_8.name())).build(new Object[0]);
        }
        catch (UnsupportedEncodingException ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
            throw new SilverpeasRuntimeException(ex.getMessage(), (Throwable)ex);
        }
        this.sharedUri = theUri;
    }

    public void withBaseUri(String baseURI) {
        URI privateUri;
        try {
            privateUri = UriBuilder.fromUri((String)baseURI).path("private/attachments").path(this.instanceId).path(this.id).path(URLEncoder.encode(this.logicalName, Charsets.UTF_8.name())).build(new Object[0]);
        }
        catch (UnsupportedEncodingException ex) {
            SilverLogger.getLogger((Object)this).error(ex.getMessage(), (Throwable)ex);
            throw new SilverpeasRuntimeException(ex.getMessage(), (Throwable)ex);
        }
        this.uri = privateUri;
    }
}

