/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.script;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.chart.ChartSettings;
import org.silverpeas.core.chat.ChatSettings;
import org.silverpeas.core.chat.servers.ChatServer;
import org.silverpeas.core.contribution.ContributionSettings;
import org.silverpeas.core.contribution.attachment.util.AttachmentSettings;
import org.silverpeas.core.date.TimeUnit;
import org.silverpeas.core.html.PermalinkRegistry;
import org.silverpeas.core.html.SupportedWebPlugin;
import org.silverpeas.core.notification.message.MessageManager;
import org.silverpeas.core.notification.user.UserNotificationServerEvent;
import org.silverpeas.core.notification.user.client.NotificationManagerSettings;
import org.silverpeas.core.reminder.ReminderSettings;
import org.silverpeas.core.subscription.SubscriptionFactory;
import org.silverpeas.core.subscription.SubscriptionResourceType;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.util.security.SecuritySettings;
import org.silverpeas.core.web.look.LayoutConfiguration;
import org.silverpeas.core.web.look.LookHelper;
import org.silverpeas.core.web.util.viewgenerator.html.GraphicElementFactory;
import org.silverpeas.core.web.util.viewgenerator.html.JavascriptBundleProducer;
import org.silverpeas.core.web.util.viewgenerator.html.JavascriptSettingProducer;
import org.silverpeas.core.webapi.documenttemplate.DocumentTemplateWebManager;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.bundle.SilverpeasBundle;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.util.StringUtil;
import org.silverpeas.kernel.util.SystemWrapper;

public class JavascriptPluginInclusion {
    private static final int NB_MONTHS = 12;
    private static final int NB_WEEK_DAYS = 7;
    private static final int SCRIPT_CONTENT_KEY_LENGTH = 150;
    private static final String ADMIN_PATH = URLUtil.getApplicationURL() + "/admin/jsp/javaScript/";
    private static final String JAVASCRIPT_PATH = URLUtil.getApplicationURL() + "/util/javaScript/";
    private static final String SERVICES_PATH_PART = "services/";
    private static final String SERVICE_PATH = JAVASCRIPT_PATH + "services/";
    private static final String FLASH_PATH = URLUtil.getApplicationURL() + "/util/flash/";
    private static final String STYLESHEET_PATH = URLUtil.getApplicationURL() + "/util/styleSheets/";
    private static final String FP_VIEWER_BASE = URLUtil.getApplicationURL() + "/media/jsp/fp";
    private static final String PDF_VIEWER_BASE = URLUtil.getApplicationURL() + "/media/jsp/pdf";
    private static final String JQUERY_PATH = JAVASCRIPT_PATH + "jquery/";
    private static final String JQUERY_CSS_PATH = STYLESHEET_PATH + "jquery/";
    private static final String ANGULARJS_PATH = JAVASCRIPT_PATH + "angularjs/";
    private static final String ANGULARJS_I18N_PATH = ANGULARJS_PATH + "i18n/";
    private static final String ANGULARJS_SERVICES_PATH = ANGULARJS_PATH + "services/";
    private static final String ANGULARJS_DIRECTIVES_PATH = ANGULARJS_PATH + "directives/";
    private static final String ANGULARJS_CONTROLLERS_PATH = ANGULARJS_PATH + "controllers/";
    private static final String ANGULAR_JS = "angular.min.js";
    private static final String ANGULAR_LOCALE_JS = "angular-locale_{0}.js";
    private static final String ANGULAR_SANITIZE_JS = "angular-sanitize.min.js";
    private static final String SILVERPEAS_ANGULAR_JS = "silverpeas-angular.js";
    private static final String ANGULAR_CKEDITOR_JS = "ng-ckeditor.js";
    private static final String SILVERPEAS_ADAPTERS_ANGULAR_JS = "silverpeas-adapters.js";
    private static final String VUE_DEV_JS = "vue.js";
    private static final String VUE_JS = "vue.min.js";
    private static final String VUEJS_PATH = JAVASCRIPT_PATH + "vuejs/";
    private static final String VUEJS_COMPONENT_PATH = VUEJS_PATH + "components/";
    private static final String SILVERPEAS_VUE_JS = "silverpeas-vuejs.js";
    private static final String SILVERPEAS_EMBED_PLAYER = "silverpeas-embed-player.js";
    private static final String SILVERPEAS_MEDIA_PLAYER = "silverpeas-media-player.js";
    private static final String FLOWPLAYER_CSS = "flowplayer-7.2.7/skin/skin.min.css";
    private static final String FLOWPLAYER_JS = "flowplayer/flowplayer-7.2.7.min.js";
    private static final String FLOWPLAYER_SWF = "flowplayer/flowplayer-7.2.7.swf";
    private static final String FLOWPLAYER_SWF_HLS = "flowplayer/flowplayerhls-7.2.7.swf";
    private static final String JQUERY_QTIP = "jquery.qtip";
    private static final String SILVERPEAS_TIP = "silverpeas-tip.js";
    private static final String JQUERY_IFRAME_AJAX_TRANSPORT = "jquery-iframe-transport";
    private static final String SILVERPEAS_PAGINATOR = "silverpeas-pagination.js";
    private static final String JQUERY_DATEPICKER = "jquery.ui.datepicker-{0}.js";
    private static final String SILVERPEAS_DATECHECKER = "silverpeas-datechecker.js";
    private static final String JQUERY_CALENDAR = "fullcalendar.min.js";
    private static final String SILVERPEAS_CALENDAR = "silverpeas-calendar.js";
    private static final String STYLESHEET_JQUERY_CALENDAR = "fullcalendar.min.css";
    private static final String PRINT_STYLESHEET_JQUERY_CALENDAR = "fullcalendar.print.min.css";
    private static final String STYLESHEET_SILVERPEAS_CALENDAR = "silverpeas-calendar.css";
    private static final String SILVERPEAS_DATEPICKER = "silverpeas-defaultDatePicker.js";
    private static final String SILVERPEAS_DATE_UTILS = "dateUtils.js";
    private static final String PAGINATION_TOOL = "smartpaginator";
    private static final String SILVERPEAS_BREADCRUMB = "silverpeas-breadcrumb.js";
    private static final String SILVERPEAS_DRAG_AND_DROP_UPLOAD_I18N_ST = "ddUploadBundle";
    private static final String SILVERPEAS_DRAG_AND_DROP_UPLOAD = "silverpeas-ddUpload.js";
    private static final String SILVERPEAS_LAYOUT = "silverpeas-layout.js";
    private static final String SILVERPEAS_PROFILE = "silverpeas-profile.js";
    private static final String SILVERPEAS_USERZOOM = "silverpeas-userZoom.js";
    private static final String SILVERPEAS_INVITME = "silverpeas-relationship.js";
    private static final String SILVERPEAS_RESPONSIBLES = "silverpeas-responsibles.js";
    private static final String SILVERPEAS_POPUP = "silverpeas-popup.js";
    private static final String SILVERPEAS_PREVIEW = "silverpeas-preview.js";
    private static final String SILVERPEAS_VIEW = "silverpeas-view.js";
    private static final String SILVERPEAS_PDC_WIDGET = "silverpeas-pdc-widgets.js";
    private static final String SILVERPEAS_PDC = "silverpeas-pdc.js";
    private static final String SILVERPEAS_SUBSCRIPTION = "silverpeas-subscription.js";
    private static final String JQUERY_NOTIFIER_PATH = JQUERY_PATH + "noty/";
    private static final String JQUERY_NOTIFIER_BASE = "jquery.noty.js";
    private static final String JQUERY_NOTIFIER_TOP = "layouts/top.js";
    private static final String JQUERY_NOTIFIER_TOPCENTER = "layouts/topCenter.js";
    private static final String JQUERY_NOTIFIER_CENTER = "layouts/center.js";
    private static final String JQUERY_NOTIFIER_THEME = "themes/silverpeas.js";
    private static final String SILVERPEAS_NOTIFIER = "silverpeas-notifier.js";
    private static final String JQUERY_TAGS = "tagit/tagit.js";
    private static final String STYLESHEET_TAGS = "tagit/tagit-stylish-yellow.css";
    private static final String SILVERPEAS_PASSWORD = "silverpeas-password.js";
    private static final String STYLESHEET_PASSWORD = "silverpeas-password.css";
    private static final String WYSIWYG_PATH = URLUtil.getApplicationURL() + "/wysiwyg/jsp/";
    private static final String JAVASCRIPT_CKEDITOR = "ckeditor/ckeditor.js";
    private static final String CODE_HIGHLIGHTER_JAVASCRIPT = "ckeditor/plugins/codesnippet/lib/highlight/highlight.pack.js";
    private static final String CODE_HIGHLIGHTER_CSS = "ckeditor/plugins/codesnippet/lib/highlight/styles/monokai_sublime.css";
    private static final String SILVERPEAS_WYSIWYG_TOOLBAR = "javaScript/wysiwygToolBar.js";
    private static final String JAVASCRIPT_TYPE = "text/javascript";
    private static final String STYLESHEET_TYPE = "text/css";
    private static final String STYLESHEET_REL = "stylesheet";
    private static final String JQUERY_SVG = "raphael.min.js";
    private static final String JQUERY_GAUGE = "justgage.min.js";
    private static final String SILVERPEAS_GAUGE = "silverpeas-gauge.js";
    private static final String JQUERY_AUTORESIZE = "autoresize.jquery.min.js";
    private static final String SILVERPEAS_TOKENIZING = "silverpeas-tkn.js";
    private static final String RATEIT_JS = "rateit/jquery.rateit.min.js";
    private static final String RATEIT_CSS = "rateit/rateit.css";
    private static final String LIGHTSLIDESHOW_JS = "slideShow/slideshow.js";
    private static final String LIGHTSLIDESHOW_CSS = "slideShow/slideshow.css";
    private static final String SILVERPEAS_IDENTITYCARD = "silverpeas-identitycard.js";
    private static final String SILVERPEAS_MYLINKS = "silverpeas-mylinks.js";
    private static final String SILVERPEAS_LANG = "silverpeas-lang.js";
    private static final String SILVERPEAS_USER_SESSION_JS = "silverpeas-user-session.js";
    private static final String SILVERPEAS_USER_NOTIFICATION_JS = "silverpeas-user-notification.js";
    private static final String TICKER_JS = "ticker/jquery.ticker.js";
    private static final String TICKER_CSS = "ticker/ticker-style.css";
    private static final String HTML2CANVAS_JS = "html2canvas.min.js";
    private static final String DOWNLOAD_JS = "download.min.js";
    private static final String VIRTUAL_KEYBOARD_PATH = URLUtil.getApplicationURL() + "/silverkeyboard";
    private static final String A11Y_PATH = URLUtil.getApplicationURL() + "/a11y";
    private static final String CHART_JS = "flot/jquery.flot.min.js";
    private static final String CHART_PIE_JS = "flot/jquery.flot.pie.min.js";
    private static final String CHART_TIME_JS = "flot/jquery.flot.time.min.js";
    private static final String CHART_CATEGORIES_JS = "flot/jquery.flot.categories.min.js";
    private static final String CHART_AXISLABEL_JS = "flot/jquery.flot.axislabels.js";
    private static final String CHART_TOOLTIP_JS = "flot/jquery.flot.tooltip.min.js";
    private static final String SILVERPEAS_CHART_JS = "silverpeas-chart.js";
    private static final String SILVERPEAS_CHART_I18N_ST = "chartBundle";
    private static final String SILVERPEAS_LIST_OF_USERS_AND_GROUPS_JS = "silverpeas-user-group-list.js";
    private static final String RESOLVE_CALLBACK = "resolve();";
    private static final String CANCEL_BUNDLE_KEY = "GML.cancel";
    private static final String OK_BUNDLE_KEY = "GML.ok";
    private static final String YES_BUNDLE_KEY = "GML.yes";
    private static final String NO_BUNDLE_KEY = "GML.no";
    private static final boolean SILVERPEAS_DEV_MODE = StringUtil.getBooleanValue((String)SystemWrapper.getInstance().getenv("SILVERPEAS_DEV_JS_MODE"));
    private static final String SILVERPEAS_CALENDAR_EVENT = "silverpeas-calendar-event";
    private static final String CALENDAR_LABEL_EVENT_RECURRENCE_TYPE = "calendar.label.event.recurrence.type";
    private static final String CALENDAR_LABEL_EVENT_RECURRENCE_MONTH = "calendar.label.event.recurrence.month";
    private static final String REMINDER_JS = "-reminder.js";

    private JavascriptPluginInclusion() {
    }

    public static Element module(String src) {
        return JavascriptPluginInclusion.script(src, s -> s.setType("module"));
    }

    public static Element script(String src) {
        return JavascriptPluginInclusion.script(src, null);
    }

    public static Element script(String src, Consumer<script> consumer) {
        String key = "$jsPlugin$script$" + src;
        if (CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)key) == null) {
            CacheAccessorProvider.getThreadCacheAccessor().getCache().put((Object)key, (Object)true);
            script script2 = new script().setType(JAVASCRIPT_TYPE).setSrc(JavascriptPluginInclusion.normalizeWebResourceUrl(src));
            if (consumer != null) {
                consumer.accept(script2);
            }
            return script2;
        }
        return new ElementContainer();
    }

    private static String generateDynamicPluginLoadingPromise(SupportedWebPlugin plugin, String src) {
        return JavascriptPluginInclusion.generatePromise(plugin, JavascriptPluginInclusion.generateDynamicPluginLoading(src, plugin.getName().toLowerCase() + "Plugin", RESOLVE_CALLBACK, null));
    }

    private static String generatePromise(SupportedWebPlugin plugin, String promiseContent) {
        String promise = "window." + plugin.getName() + "_PROMISE";
        promise = promise + "=new Promise(function(resolve, reject){";
        promise = promise + promiseContent;
        promise = promise + "});";
        return promise;
    }

    private static String generateDynamicPluginLoading(String src, String jqPluginName, String jsCallbackContentOnSuccessfulLoad, String jsCallback) {
        String key = "$jsDynamicPlugin$script$" + src;
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        if (cache.get((Object)key) == null) {
            cache.put((Object)key, (Object)true);
            StringBuilder sb = new StringBuilder();
            sb.append("jQuery(document).ready(function() {");
            sb.append("  if (typeof jQuery.").append(jqPluginName).append(" === 'undefined' &&");
            sb.append("      typeof window.").append(jqPluginName).append(" === 'undefined') {");
            sb.append("    jQuery.ajax({type:'GET',url:'").append(JavascriptPluginInclusion.normalizeWebResourceUrl(src)).append("',dataType:'script',cache:true,success:function() {");
            if (StringUtil.isDefined((String)jsCallbackContentOnSuccessfulLoad)) {
                sb.append("    ").append(jsCallbackContentOnSuccessfulLoad);
            }
            if (StringUtil.isDefined((String)jsCallback)) {
                sb.append("    ").append(jsCallback);
            }
            sb.append("    }})");
            sb.append("  } else {");
            if (StringUtil.isDefined((String)jsCallback)) {
                sb.append("    ").append(jsCallback);
            }
            sb.append("  }");
            sb.append("});");
            return sb.toString();
        }
        return "";
    }

    public static Element scriptContent(String content) {
        String key = "$jsPlugin$scriptContent$" + StringUtil.truncate((String)content, (int)150);
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        if (cache.get((Object)key) == null) {
            cache.put((Object)key, (Object)true);
            return new script().setType(JAVASCRIPT_TYPE).addElement(content);
        }
        return new ElementContainer();
    }

    public static Element print(String href) {
        return JavascriptPluginInclusion.link(href, l -> l.setMedia("print"));
    }

    public static Element link(String href) {
        return JavascriptPluginInclusion.link(href, null);
    }

    public static Element link(String href, Consumer<link> consumer) {
        String key = "$jsPlugin$css$" + href;
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        if (cache.get((Object)key) == null) {
            cache.put((Object)key, (Object)true);
            link link2 = new link().setType(STYLESHEET_TYPE).setRel(STYLESHEET_REL).setHref(JavascriptPluginInclusion.normalizeWebResourceUrl(href));
            if (consumer != null) {
                consumer.accept(link2);
            }
            return link2;
        }
        return new ElementContainer();
    }

    public static ElementContainer includeMinimalSilverpeas(ElementContainer xhtml, String language) {
        xhtml.addElement(JavascriptPluginInclusion.scriptContent("window.webContext='" + URLUtil.getApplicationURL() + "';"));
        JavascriptPluginInclusion.includePolyfills(xhtml);
        JavascriptPluginInclusion.includeJQuery(xhtml);
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "/silverpeas.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "/silverpeas-i18n.js"));
        JavascriptPluginInclusion.includeSecurityTokenizing(xhtml);
        JavascriptPluginInclusion.includeA11y(xhtml, language);
        return xhtml;
    }

    static ElementContainer includeCkeditorAddOns(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_IDENTITYCARD));
        return xhtml;
    }

    static ElementContainer includePolyfills(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "polyfill/unorm.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "polyfill/array.generics.min.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "polyfill/es6-promise.min.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "polyfill/classList.min.js"));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent("window.EVENT_SOURCE_POLYFILL_ACTIVATED=(typeof window.EventSource === 'undefined');"));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "polyfill/eventsource.min.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "polyfill/customEventIEPolyfill.min.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "polyfill/eventListenerIEPolyfill.min.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "polyfill/silverpeas-polyfills.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "polyfill/silverpeas-fscreen.js"));
        return xhtml;
    }

    static ElementContainer includeAngular(ElementContainer xhtml, String language) {
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_PATH + ANGULAR_JS));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_I18N_PATH + MessageFormat.format(ANGULAR_LOCALE_JS, language)));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_PATH + ANGULAR_SANITIZE_JS));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_PATH + SILVERPEAS_ANGULAR_JS));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_PATH + SILVERPEAS_ADAPTERS_ANGULAR_JS));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + "silverpeas-button.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + "silverpeas-permalink.js"));
        return xhtml;
    }

    static ElementContainer includeVueJs(ElementContainer xhtml) {
        if (SILVERPEAS_DEV_MODE) {
            xhtml.addElement(JavascriptPluginInclusion.script(VUEJS_PATH + VUE_DEV_JS));
        } else {
            xhtml.addElement(JavascriptPluginInclusion.script(VUEJS_PATH + VUE_JS));
        }
        xhtml.addElement(JavascriptPluginInclusion.script(VUEJS_PATH + SILVERPEAS_VUE_JS));
        xhtml.addElement(JavascriptPluginInclusion.link(VUEJS_COMPONENT_PATH + "silverpeas-commons.css"));
        xhtml.addElement(JavascriptPluginInclusion.script(VUEJS_COMPONENT_PATH + "silverpeas-commons.js"));
        return xhtml;
    }

    static ElementContainer includeEmbedPlayer(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_EMBED_PLAYER));
        return xhtml;
    }

    static ElementContainer includeMediaPlayer(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptSettingProducer.settingVariableName("MediaPlayerSettings").add("media.player.flowplayer.swf", FLASH_PATH + FLOWPLAYER_SWF).add("media.player.flowplayer.swf.hls", FLASH_PATH + FLOWPLAYER_SWF_HLS).produce()));
        xhtml.addElement(JavascriptPluginInclusion.link(STYLESHEET_PATH + FLOWPLAYER_CSS));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + FLOWPLAYER_JS));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_MEDIA_PLAYER));
        return xhtml;
    }

    static ElementContainer includeQTip(ElementContainer xhtml, String language) {
        xhtml.addElement(JavascriptPluginInclusion.link(JQUERY_CSS_PATH + "jquery.qtip.min.css"));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + "jquery.qtip.min.js"));
        LocalizationBundle bundle = ResourceLocator.getGeneralLocalizationBundle((String)language);
        JavascriptBundleProducer bundleProducer = JavascriptBundleProducer.bundleVariableName("TipBundle");
        bundleProducer.add("tip.c", bundle.getString("GML.close"));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(bundleProducer.produce()));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_TIP));
        return xhtml;
    }

    static ElementContainer includePdc(ElementContainer xhtml, String language, boolean dynamically) {
        JavascriptSettingProducer settingProducer = JavascriptSettingProducer.settingVariableName("PdcSettings");
        settingProducer.add("pdc.e.i", "classification");
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(settingProducer.produce()));
        LocalizationBundle bundle = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.pdcPeas.multilang.pdcBundle", (String)language);
        JavascriptBundleProducer bundleProducer = JavascriptBundleProducer.bundleVariableName("PdcBundle");
        bundleProducer.add("pdc.l.o", bundle.getString(OK_BUNDLE_KEY));
        bundleProducer.add("pdc.l.c", bundle.getString(CANCEL_BUNDLE_KEY));
        bundleProducer.add("pdc.e.ma", bundle.getString("pdcPeas.theContent") + " " + bundle.getString("pdcPeas.MustContainsMandatoryAxis"));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(bundleProducer.produce()));
        if (!dynamically) {
            xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_PDC_WIDGET));
            xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_PDC));
            xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + "util/silverpeas-pdc.js"));
        } else {
            xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptPluginInclusion.generatePromise(SupportedWebPlugin.Constants.PDC, JavascriptPluginInclusion.generateDynamicPluginLoading(JAVASCRIPT_PATH + SILVERPEAS_PDC_WIDGET, SupportedWebPlugin.Constants.PDC.getName().toLowerCase() + "Plugin", JavascriptPluginInclusion.generateDynamicPluginLoading(JAVASCRIPT_PATH + SILVERPEAS_PDC, "__pdcDynLoad", RESOLVE_CALLBACK, null), null))));
        }
        return xhtml;
    }

    static ElementContainer includeRating(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.link(JQUERY_PATH + RATEIT_CSS));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + RATEIT_JS));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + "silverpeas-rating.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_SERVICES_PATH + "silverpeas-rating.js"));
        return xhtml;
    }

    static ElementContainer includeToggle(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + "silverpeas-toggle.js"));
        return xhtml;
    }

    static ElementContainer includeTabsWebComponent(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + "silverpeas-tabs.js"));
        return xhtml;
    }

    static ElementContainer includeColorPickerWebComponent(ElementContainer xhtml, String language) {
        JavascriptPluginInclusion.includeQTip(xhtml, language);
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + "util/silverpeas-color-picker.js"));
        return xhtml;
    }

    static ElementContainer includeLightweightSlideshow(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.link(JQUERY_PATH + LIGHTSLIDESHOW_CSS));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + LIGHTSLIDESHOW_JS));
        return xhtml;
    }

    static ElementContainer includeTicker(ElementContainer xhtml, String language) {
        xhtml.addElement(JavascriptPluginInclusion.link(JQUERY_PATH + TICKER_CSS));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptBundleProducer.bundleVariableName("TickerBundle").add((SilverpeasBundle)ResourceLocator.getLocalizationBundle((String)"org.silverpeas.lookSilverpeasV5.multilang.lookBundle", (String)language), "lookSilverpeasV5.ticker.date.yesterday", "lookSilverpeasV5.ticker.date.daysAgo", "lookSilverpeasV5.ticker.notifications.permission.request").produce()));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptPluginInclusion.generateDynamicPluginLoadingPromise(SupportedWebPlugin.Constants.TICKER, JQUERY_PATH + TICKER_JS)));
        return xhtml;
    }

    static ElementContainer includeUserSession(ElementContainer xhtml, LookHelper lookHelper) {
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptSettingProducer.settingVariableName("UserSessionSettings").add("us.cu.nb.i", lookHelper.getNBConnectedUsers()).add("us.cu.v.u", URLUtil.getApplicationURL() + "/Rdirectory/jsp/connected").produce()));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptPluginInclusion.generateDynamicPluginLoadingPromise(SupportedWebPlugin.Constants.USERSESSION, JAVASCRIPT_PATH + SILVERPEAS_USER_SESSION_JS)));
        return xhtml;
    }

    static ElementContainer includeUserNotification(ElementContainer xhtml) {
        String myNotificationUrl = URLUtil.getURL((String)"SILVERMAIL", null, null) + "Main";
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptSettingProducer.settingVariableName("UserNotificationSettings").add("un.nbu.i", UserNotificationServerEvent.getNbUnreadFor((String)User.getCurrentRequester().getId())).add("un.v.u", URLUtil.getApplicationURL() + myNotificationUrl).add("un.d.i.u", URLUtil.getApplicationURL() + NotificationManagerSettings.getUserNotificationDesktopIconUrl()).produce()));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptPluginInclusion.generateDynamicPluginLoadingPromise(SupportedWebPlugin.Constants.USERNOTIFICATION, JAVASCRIPT_PATH + SILVERPEAS_USER_NOTIFICATION_JS)));
        xhtml.addElement(JavascriptPluginInclusion.script(VUEJS_COMPONENT_PATH + "notification/silverpeas-user-notifications.js"));
        return xhtml;
    }

    public static ElementContainer includeIFrameAjaxTransport(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + "jquery-iframe-transport.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + "jquery-iframe-transport-helper.js"));
        return xhtml;
    }

    static ElementContainer includeDatePicker(ElementContainer xhtml, String language) {
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + MessageFormat.format(JQUERY_DATEPICKER, language)));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_DATEPICKER));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_DATE_UTILS));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_DATECHECKER));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent("jQuery.datechecker.settings.language = '" + language + "';"));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + "util/silverpeas-date-picker.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(VUEJS_COMPONENT_PATH + "silverpeas-date-picker.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + "util/silverpeas-time-picker.js"));
        return xhtml;
    }

    static ElementContainer includePagination(ElementContainer xhtml, String language) {
        int currentNbItemsPerPage;
        LocalizationBundle multilang = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.util.viewGenerator.multilang.graphicElementFactoryBundle", (String)language);
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptBundleProducer.bundleVariableName("PaginationBundle").add("g.p.f", multilang.getString("GEF.pagination.firstPage")).add("g.p.p", multilang.getString("GEF.pagination.previousPage")).add("g.p.n", multilang.getString("GEF.pagination.nextPage")).add("g.p.l", multilang.getString("GEF.pagination.lastPage")).add("g.p.p.p", multilang.getString("GEF.pagination.perPage")).add("g.p.a", multilang.getString("GEF.pagination.all")).add("g.p.a.t", multilang.getString("GEF.pagination.all.title")).produce()));
        SettingBundle settings = GraphicElementFactory.getSettings();
        Stream<Object> nbItemsPerPage = Stream.empty();
        int index = 1;
        while ((currentNbItemsPerPage = settings.getInteger("Pagination.NbItemPerPage." + index++, -1)) > -1) {
            nbItemsPerPage = Stream.concat(nbItemsPerPage, Stream.of(Integer.valueOf(currentNbItemsPerPage)));
        }
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptSettingProducer.settingVariableName("PaginationSettings").add("p.i.p", settings.getString("IconsPath")).add("p.n.p.t", settings.getInteger("Pagination.NbPageThreshold", 6)).add("p.i.t", settings.getInteger("Pagination.IndexThreshold", 5)).add("p.n.p.p.t", settings.getInteger("Pagination.NumberPerPageThreshold", 25)).add("p.j.t", settings.getInteger("Pagination.JumperThreshold", 12)).add("p.n.i.p.p", nbItemsPerPage, false).add("p.p.a.t", settings.getInteger("Pagination.PaginationAllThreshold", 500)).add("i.q.m.c", settings.getInteger("input.query.min.chars", 3)).produce()));
        xhtml.addElement(JavascriptPluginInclusion.link(JQUERY_CSS_PATH + "smartpaginator.css"));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + "smartpaginator.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + SILVERPEAS_PAGINATOR));
        xhtml.addElement(JavascriptPluginInclusion.link(VUEJS_COMPONENT_PATH + "silverpeas-pagination.css"));
        xhtml.addElement(JavascriptPluginInclusion.script(VUEJS_COMPONENT_PATH + SILVERPEAS_PAGINATOR));
        return xhtml;
    }

    static ElementContainer includeBreadCrumb(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_BREADCRUMB));
        return xhtml;
    }

    static ElementContainer includeUserZoom(ElementContainer xhtml, String language) {
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_SERVICES_PATH + SILVERPEAS_PROFILE));
        JavascriptPluginInclusion.includeRelationship(xhtml, language);
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_USERZOOM));
        return xhtml;
    }

    static ElementContainer includeRelationship(ElementContainer xhtml, String language) {
        LocalizationBundle bundle = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.social.multilang.socialNetworkBundle", (String)language);
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptBundleProducer.bundleVariableName("RelationshipBundle").add((SilverpeasBundle)ResourceLocator.getGeneralLocalizationBundle((String)language), OK_BUNDLE_KEY, CANCEL_BUNDLE_KEY, YES_BUNDLE_KEY, NO_BUNDLE_KEY, "GML.notification.message").add((SilverpeasBundle)bundle, "myProfile.invitations.dialog.cancel.title", "myProfile.invitations.dialog.cancel.message", "myProfile.invitations.cancel.feedback", "myProfile.invitations.dialog.ignore.title", "myProfile.invitations.dialog.ignore.message", "myProfile.invitations.ignore.feedback", "myProfile.invitations.sent.feedback", "myProfile.invitations.dialog.accept.title", "myProfile.invitations.dialog.accept.message", "myProfile.invitations.accept.feedback", "myProfile.relations.delete.feedback", "myProfile.relations.dialog.delete.title", "myProfile.relations.dialog.delete.message").produce()));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_SERVICES_PATH + SILVERPEAS_PROFILE));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_INVITME));
        return xhtml;
    }

    static ElementContainer includeWysiwygEditor(ElementContainer xhtml, String language) {
        xhtml.addElement(JavascriptPluginInclusion.link(WYSIWYG_PATH + CODE_HIGHLIGHTER_CSS));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent("window.CKEDITOR_BASEPATH = '" + URLUtil.getApplicationURL() + "/wysiwyg/jsp/ckeditor/';"));
        xhtml.addElement(JavascriptPluginInclusion.script(WYSIWYG_PATH + JAVASCRIPT_CKEDITOR));
        xhtml.addElement(JavascriptPluginInclusion.script(WYSIWYG_PATH + CODE_HIGHLIGHTER_JAVASCRIPT));
        xhtml.addElement(JavascriptPluginInclusion.script(WYSIWYG_PATH + SILVERPEAS_WYSIWYG_TOOLBAR));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_PATH + ANGULAR_CKEDITOR_JS));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent("hljs.initHighlightingOnLoad();"));
        JavascriptPluginInclusion.includeDragAndDropUpload(xhtml, language);
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "silverpeas-ddUpload-ckeditor.js"));
        return xhtml;
    }

    static ElementContainer includeResponsibles(ElementContainer xhtml, String language) {
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_RESPONSIBLES));
        String responsiblePluginLabels = "jQuery.responsibles.labels.platformResponsible = '" + ResourceLocator.getGeneralLocalizationBundle((String)language).getString("GML.platform.responsibles") + "';jQuery.responsibles.labels.sendMessage = '" + ResourceLocator.getGeneralLocalizationBundle((String)language).getString("GML.notification.send") + "';";
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(responsiblePluginLabels));
        return xhtml;
    }

    static ElementContainer includePopup(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.scriptContent("var popupViewGeneratorIconPath='" + GraphicElementFactory.getIconsPath() + "';"));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_POPUP));
        return xhtml;
    }

    private static String getDynamicPopupJavascriptLoadContent(String jsCallback) {
        return JavascriptPluginInclusion.generateDynamicPluginLoading(JAVASCRIPT_PATH + SILVERPEAS_POPUP, "popup", "window.popupViewGeneratorIconPath='" + GraphicElementFactory.getIconsPath() + "';", jsCallback);
    }

    static ElementContainer includePreview(ElementContainer xhtml) {
        JavascriptPluginInclusion.includePopup(xhtml);
        JavascriptPluginInclusion.includeEmbedPlayer(xhtml);
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptSettingProducer.settingVariableName("ViewSettings").add("v.ep", JavascriptPluginInclusion.normalizeWebResourceUrl(JAVASCRIPT_PATH + SILVERPEAS_EMBED_PLAYER)).add("dac.cns", AttachmentSettings.displayableAsContentComponentNames(), true).produce()));
        xhtml.addElement(JavascriptPluginInclusion.script(SERVICE_PATH + "content/silverpeas-document-view-service.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_PREVIEW));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_VIEW));
        return xhtml;
    }

    static ElementContainer includeFlexPaperViewer(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.link(FP_VIEWER_BASE + "/viewer.css"));
        xhtml.addElement(JavascriptPluginInclusion.script(FP_VIEWER_BASE + "/core/flexpaper.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(FP_VIEWER_BASE + "/viewer.js"));
        return xhtml;
    }

    static ElementContainer includePdfViewer(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.link(PDF_VIEWER_BASE + "/locale/locale.json", l -> l.setType("application/l10n")));
        LocalizationBundle bundle = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.viewer.multilang.viewerBundle", (String)"fr");
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptBundleProducer.bundleVariableName("PdfViewerBundle").add((SilverpeasBundle)bundle, bundle.specificKeySet().toArray(new String[0])).produce()));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptSettingProducer.settingVariableName("PdfViewerSettings").add("p.i.p", PDF_VIEWER_BASE + "/images/").add("p.w.s", PDF_VIEWER_BASE + "/core/pdf.worker.min.js").add("p.s.b.s", PDF_VIEWER_BASE + "/core/pdf.sandbox.min.js").add("p.c.p", PDF_VIEWER_BASE + "/cmaps/").produce()));
        xhtml.addElement(JavascriptPluginInclusion.link(PDF_VIEWER_BASE + "/viewer.min.css"));
        xhtml.addElement(JavascriptPluginInclusion.link(PDF_VIEWER_BASE + "/sp-viewer.css"));
        xhtml.addElement(JavascriptPluginInclusion.link(PDF_VIEWER_BASE + "/sp-viewer-addon.css"));
        xhtml.addElement(JavascriptPluginInclusion.module(PDF_VIEWER_BASE + "/core/pdf.min.js"));
        xhtml.addElement(JavascriptPluginInclusion.module(PDF_VIEWER_BASE + "/viewer.min.js"));
        return xhtml;
    }

    static ElementContainer includeNotifier(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + JQUERY_NOTIFIER_BASE));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_NOTIFIER_PATH + JQUERY_NOTIFIER_TOP));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_NOTIFIER_PATH + JQUERY_NOTIFIER_TOPCENTER));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_NOTIFIER_PATH + JQUERY_NOTIFIER_CENTER));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_NOTIFIER_PATH + "layouts/centerLeft.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_NOTIFIER_PATH + JQUERY_NOTIFIER_THEME));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_NOTIFIER));
        StringBuilder script2 = new StringBuilder();
        script2.append("notySetupAjaxMessages();");
        String registredKeyOfMessages = MessageManager.getRegistredKey();
        if (StringUtil.isDefined((String)registredKeyOfMessages)) {
            script2.append("notyRegistredMessages('").append(registredKeyOfMessages).append("');");
        }
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(script2.toString()));
        return xhtml;
    }

    static ElementContainer includePassword(ElementContainer xhtml) {
        JavascriptPluginInclusion.includePopup(xhtml);
        xhtml.addElement(JavascriptPluginInclusion.link(STYLESHEET_PATH + STYLESHEET_PASSWORD));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_PASSWORD));
        return xhtml;
    }

    private static ElementContainer includeAttendeeWebComponent(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + "util/silverpeas-attendees.js"));
        return xhtml;
    }

    static ElementContainer includeAttachment(ElementContainer xhtml, String language) {
        JavascriptPluginInclusion.includePreview(xhtml);
        JavascriptPluginInclusion.includeFileManager(xhtml);
        JavascriptPluginInclusion.includeDragAndDropUpload(xhtml, language);
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + "util/silverpeas-attachment.js"));
        xhtml.addElement(JavascriptPluginInclusion.link(VUEJS_COMPONENT_PATH + "content/silverpeas-attachment.css"));
        xhtml.addElement(JavascriptPluginInclusion.script(VUEJS_COMPONENT_PATH + "content/silverpeas-attachment.js"));
        return xhtml;
    }

    static ElementContainer includeCalendar(ElementContainer xhtml, String language) {
        int i;
        JavascriptPluginInclusion.includePdc(xhtml, language, false);
        JavascriptPluginInclusion.includePanes(xhtml);
        JavascriptPluginInclusion.includeCrud(xhtml);
        JavascriptPluginInclusion.includeAttachment(xhtml, language);
        JavascriptPluginInclusion.includeQTip(xhtml, language);
        JavascriptPluginInclusion.includeTabsWebComponent(xhtml);
        JavascriptPluginInclusion.includeColorPickerWebComponent(xhtml, language);
        JavascriptPluginInclusion.includeDatePicker(xhtml, language);
        JavascriptPluginInclusion.includeAttendeeWebComponent(xhtml);
        JavascriptPluginInclusion.includeDragAndDropUpload(xhtml, language);
        JavascriptPluginInclusion.includeWysiwygEditor(xhtml, language);
        JavascriptPluginInclusion.includeContributionReminder(xhtml, language);
        JavascriptPluginInclusion.includeBasketSelection(xhtml);
        SettingBundle calendarSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.calendar.settings.calendar");
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptSettingProducer.settingVariableName("CalendarSettings").add("c.c", Arrays.stream(calendarSettings.getString("calendar.ui.colors").split(",")), true).add("c.v.l.d.l", calendarSettings.getString("calendar.views.list.dayHeader.format.left", "")).add("c.v.l.d.r", calendarSettings.getString("calendar.views.list.dayHeader.format.right", "")).add("c.v.d.e", calendarSettings.getBoolean("calendar.views.day.endHour", true)).add("c.v.w.e", calendarSettings.getBoolean("calendar.views.week.endHour", true)).add("c.v.m.e", calendarSettings.getBoolean("calendar.views.month.endHour", true)).add("c.v.y.e", calendarSettings.getBoolean("calendar.views.year.endHour", true)).produce()));
        LocalizationBundle bundle = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.calendar.multilang.calendarBundle", (String)language);
        JavascriptBundleProducer bundleProducer = JavascriptBundleProducer.bundleVariableName("CalendarBundle");
        for (i = 0; i < 12; ++i) {
            bundleProducer.add("c.m." + i, bundle.getString("GML.mois" + i));
        }
        for (i = 0; i < 7; ++i) {
            bundleProducer.add("c.d." + i, bundle.getString("GML.jour" + (i + 1)));
            bundleProducer.add("c.sd." + i, bundle.getString("GML.shortJour" + (i + 1)));
        }
        bundleProducer.add("c.t", bundle.getString("GML.Today"));
        bundleProducer.add("c.m", bundle.getString("GML.month"));
        bundleProducer.add("c.w", bundle.getString("GML.week"));
        bundleProducer.add("c.d", bundle.getString("GML.day"));
        bundleProducer.add("c.e.n", bundle.getString("calendar.label.event.none"));
        bundleProducer.add("c.e.v.public", bundle.getString("calendar.label.event.visibility.public"));
        bundleProducer.add("c.e.v.private", bundle.getString("calendar.label.event.visibility.private"));
        bundleProducer.add("c.e.p.normal", bundle.getString("calendar.label.event.priority.normal"));
        bundleProducer.add("c.e.p.high", bundle.getString("calendar.label.event.priority.high"));
        bundleProducer.add("c.e.r.none", bundle.getString("calendar.label.event.recurrence.type.none"));
        bundleProducer.add("c.e.r.day", bundle.getString("calendar.label.event.recurrence.type.day"));
        bundleProducer.add("c.e.r.week", bundle.getString("calendar.label.event.recurrence.type.week"));
        bundleProducer.add("c.e.r.month", bundle.getString("calendar.label.event.recurrence.type.month"));
        bundleProducer.add("c.e.r.year", bundle.getString("calendar.label.event.recurrence.type.year"));
        bundleProducer.add("c.e.r.day.s", bundle.getString("calendar.label.event.recurrence.type.day.short"));
        bundleProducer.add("c.e.r.week.s", bundle.getString("calendar.label.event.recurrence.type.week.short"));
        bundleProducer.add("c.e.r.month.s", bundle.getString("calendar.label.event.recurrence.type.month.short"));
        bundleProducer.add("c.e.r.year.s", bundle.getString("calendar.label.event.recurrence.type.year.short"));
        bundleProducer.add("c.e.r.m.r.first", bundle.getString("calendar.label.event.recurrence.month.rule.dayofweek.first"));
        bundleProducer.add("c.e.r.m.r.second", bundle.getString("calendar.label.event.recurrence.month.rule.dayofweek.second"));
        bundleProducer.add("c.e.r.m.r.third", bundle.getString("calendar.label.event.recurrence.month.rule.dayofweek.third"));
        bundleProducer.add("c.e.r.m.r.fourth", bundle.getString("calendar.label.event.recurrence.month.rule.dayofweek.fourth"));
        bundleProducer.add("c.e.r.m.r.last", bundle.getString("calendar.label.event.recurrence.month.rule.dayofweek.last"));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(bundleProducer.produce()));
        xhtml.addElement(JavascriptPluginInclusion.link(JQUERY_CSS_PATH + STYLESHEET_JQUERY_CALENDAR));
        xhtml.addElement(JavascriptPluginInclusion.print(JQUERY_CSS_PATH + PRINT_STYLESHEET_JQUERY_CALENDAR));
        xhtml.addElement(JavascriptPluginInclusion.link(STYLESHEET_PATH + STYLESHEET_SILVERPEAS_CALENDAR));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + JQUERY_CALENDAR));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_CALENDAR));
        String calendarPath = "calendar/";
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + calendarPath + "silverpeas-calendar-event-reminder.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + calendarPath + "silverpeas-calendar-management.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + calendarPath + "silverpeas-calendar-event-management.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + calendarPath + "silverpeas-calendar-event-occurrence-tip.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + calendarPath + "silverpeas-calendar-event-occurrence-list.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_SERVICES_PATH + calendarPath + SILVERPEAS_CALENDAR));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + calendarPath + SILVERPEAS_CALENDAR));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + calendarPath + "silverpeas-calendar-list.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + calendarPath + "silverpeas-calendar-event-form.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + calendarPath + "silverpeas-calendar-event-view.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_CONTROLLERS_PATH + calendarPath + SILVERPEAS_CALENDAR));
        return xhtml;
    }

    static ElementContainer includeGauge(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + JQUERY_SVG));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + JQUERY_GAUGE));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_GAUGE));
        return xhtml;
    }

    public static ElementContainer includeAutoresize(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + JQUERY_AUTORESIZE));
        return xhtml;
    }

    static ElementContainer includeJQueryCss(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.link(JQUERY_CSS_PATH + "ui-lightness/jquery-ui.min.css"));
        return xhtml;
    }

    static ElementContainer includeJQuery(ElementContainer xhtml) {
        JavascriptPluginInclusion.includeJQueryCss(xhtml);
        String spJQueryScriptName = "silverpeas-jquery.js";
        Element spJQueryScript = JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "silverpeas-jquery.js");
        boolean minifiedVersion = Objects.requireNonNull((Boolean)CacheAccessorProvider.getApplicationCacheAccessor().getCache().computeIfAbsent((Object)"silverpeas-jquery.js", Boolean.class, () -> !spJQueryScript.toString().contains("silverpeas-jquery.js")));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + "jquery-3.3.1.min.js"));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent("jQuery.migrateTrace = " + minifiedVersion + ";"));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent("jQuery.migrateMute = " + minifiedVersion + ";"));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + "jquery-migrate-3.0.1.min.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + "jquery-ui.min.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + "jquery.json-2.3.min.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "i18n.properties.js"));
        xhtml.addElement(spJQueryScript);
        return xhtml;
    }

    static ElementContainer includeTags(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.link(JQUERY_PATH + STYLESHEET_TAGS));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + JQUERY_TAGS));
        return xhtml;
    }

    static ElementContainer includeSecurityTokenizing(ElementContainer xhtml) {
        if (SecuritySettings.isWebSecurityByTokensEnabled()) {
            xhtml.addElement((Element)new script().setType(JAVASCRIPT_TYPE).setSrc(JAVASCRIPT_PATH + "silverpeas-tkn.js?_=" + System.currentTimeMillis()));
        }
        String setTokensCondition = "if(typeof setTokens === 'function')";
        String sb = "function applyTokenSecurity(targetContainerSelector){" + setTokensCondition + "{setTokens(targetContainerSelector);}}function applyTokenSecurityOnMenu(){" + setTokensCondition + "{setTokens('#menubar-creation-actions');}}";
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(sb));
        return xhtml;
    }

    static ElementContainer includeMylinks(ElementContainer xhtml) {
        JavascriptPluginInclusion.includeAdminServices(xhtml);
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_MYLINKS));
        return xhtml;
    }

    static ElementContainer includeAdminSpaceHomepage(ElementContainer xhtml) {
        JavascriptPluginInclusion.includeAdminServices(xhtml);
        String vueJsComponentPath = URLUtil.getApplicationURL() + "/jobStartPagePeas/jsp/javascript/vuejs/components/";
        xhtml.addElement(JavascriptPluginInclusion.link(vueJsComponentPath + "silverpeas-admin-space-homepage.css"));
        xhtml.addElement(JavascriptPluginInclusion.script(vueJsComponentPath + "silverpeas-admin-space-homepage.js"));
        return xhtml;
    }

    static ElementContainer includeAdminServices(ElementContainer xhtml) {
        String servicePath = ADMIN_PATH + SERVICES_PATH_PART;
        xhtml.addElement(JavascriptPluginInclusion.script(servicePath + "silverpeas-admin-space-services.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(servicePath + "silverpeas-admin-instance-services.js"));
        return xhtml;
    }

    static ElementContainer includeSpaceAndComponentBrowser(ElementContainer xhtml) {
        JavascriptPluginInclusion.includeAdminServices(xhtml);
        String vueJsComponentPath = VUEJS_COMPONENT_PATH + "admin/";
        xhtml.addElement(JavascriptPluginInclusion.link(vueJsComponentPath + "silverpeas-space-and-component-browser.css"));
        xhtml.addElement(JavascriptPluginInclusion.script(vueJsComponentPath + "silverpeas-space-and-component-browser.js"));
        return xhtml;
    }

    static ElementContainer includeSpaceAndComponentSelector(ElementContainer xhtml) {
        JavascriptPluginInclusion.includeSpaceAndComponentBrowser(xhtml);
        String vueJsComponentPath = VUEJS_COMPONENT_PATH + "admin/";
        xhtml.addElement(JavascriptPluginInclusion.link(vueJsComponentPath + "silverpeas-space-and-component-selector.css"));
        xhtml.addElement(JavascriptPluginInclusion.script(vueJsComponentPath + "silverpeas-space-and-component-selector.js"));
        return xhtml;
    }

    static ElementContainer includeLang(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_LANG));
        return xhtml;
    }

    private static ElementContainer includeHtml2CanvasAndDownload(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + HTML2CANVAS_JS));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + DOWNLOAD_JS));
        return xhtml;
    }

    static ElementContainer includeChart(ElementContainer xhtml, String language) {
        JavascriptPluginInclusion.includeHtml2CanvasAndDownload(xhtml);
        JavascriptPluginInclusion.includeDatePicker(xhtml, language);
        JavascriptPluginInclusion.includeQTip(xhtml, language);
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + CHART_JS));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + CHART_PIE_JS));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + CHART_TIME_JS));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + CHART_CATEGORIES_JS));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + CHART_AXISLABEL_JS));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + CHART_TOOLTIP_JS));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent("var defaultChartColors = " + ChartSettings.getDefaultPieChartColorsAsJson() + "; var chartPieCombinationThreshold = " + ChartSettings.getThresholdOfPieCombination() + ";"));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptBundleProducer.fromCoreTemplate("chart", SILVERPEAS_CHART_I18N_ST, language)));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_CHART_JS));
        return xhtml;
    }

    static ElementContainer includeChat(ElementContainer xhtml) {
        if (!ChatServer.isEnabled()) {
            return xhtml;
        }
        JavascriptSettingProducer settingBundle = JavascriptSettingProducer.settingVariableName("SilverChatSettings");
        String chatDir = URLUtil.getApplicationURL() + "/chat/";
        ChatSettings chatSettings = ChatSettings.get();
        String silverpeasChatClientId = chatSettings.getSilverpeasChatClientId();
        if (silverpeasChatClientId.equals("jsxc")) {
            String jsxcDir = chatDir + "jsxc/";
            xhtml.addElement(JavascriptPluginInclusion.script(jsxcDir + "lib/jquery.fullscreen.js"));
            xhtml.addElement(JavascriptPluginInclusion.script(jsxcDir + "lib/jquery.slimscroll.js"));
            xhtml.addElement(JavascriptPluginInclusion.script(jsxcDir + "lib/jsxc.dep.min.js"));
            xhtml.addElement(JavascriptPluginInclusion.script(jsxcDir + "jsxc.min.js"));
            xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "silverpeas-chat-resizable.js"));
            xhtml.addElement(JavascriptPluginInclusion.script(chatDir + "js/silverchat.min.js"));
            xhtml.addElement(JavascriptPluginInclusion.link(jsxcDir + "css/jsxc.css"));
            xhtml.addElement(JavascriptPluginInclusion.link(jsxcDir + "css/magnific-popup.css"));
        } else if (silverpeasChatClientId.equals("conversejs")) {
            Element link2;
            String converseDir = chatDir + "converse/";
            xhtml.addElement(JavascriptPluginInclusion.script(converseDir + "converse.min.js"));
            xhtml.addElement(JavascriptPluginInclusion.script(chatDir + "converse-plugins/silverpeas-commons.min.js"));
            xhtml.addElement(JavascriptPluginInclusion.script(chatDir + "converse-plugins/silverpeas-muc-invitations.min.js"));
            xhtml.addElement(JavascriptPluginInclusion.script(chatDir + "converse-plugins/silverpeas-muc-destroy.min.js"));
            xhtml.addElement(JavascriptPluginInclusion.script(chatDir + "converse-plugins/silverpeas-sp-permalink.min.js"));
            if (chatSettings.isReplyToEnabled() || chatSettings.isReactionToEnabled()) {
                xhtml.addElement(JavascriptPluginInclusion.script(chatDir + "converse-plugins/actions.min.js"));
            }
            if (chatSettings.isVisioEnabled()) {
                settingBundle.add("v.u", chatSettings.getVisioUrl());
                xhtml.addElement(JavascriptPluginInclusion.script(chatDir + "converse-plugins/jitsimeet.min.js"));
            }
            if (chatSettings.isScreencastEnabled()) {
                xhtml.addElement(JavascriptPluginInclusion.script(chatDir + "converse-plugins/screencast.min.js"));
            }
            if ((link2 = JavascriptPluginInclusion.link(converseDir + "converse.min.css")) instanceof link) {
                ((link)link2).setMedia("screen");
                xhtml.addElement(link2);
            }
            xhtml.addElement(JavascriptPluginInclusion.script(chatDir + "js/silverpeas-converse.js"));
        }
        xhtml.addElement(JavascriptPluginInclusion.link(chatDir + "css/silverchat.css"));
        xhtml.addElement(JavascriptPluginInclusion.link(chatDir + "css/silverpeas-converse.css"));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(settingBundle.add("un.d.i.u", URLUtil.getApplicationURL() + NotificationManagerSettings.getUserNotificationDesktopIconUrl()).produce()));
        return xhtml;
    }

    static ElementContainer includeAddressCommons(ElementContainer xhtml, String language) {
        JavascriptSettingProducer settingBundle = JavascriptSettingProducer.settingVariableName("AddressFormatSettings");
        SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.address.settings.address");
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(settingBundle.add("a.f.c.c", language.toUpperCase()).add("a.f.a", settings.getBoolean("address.format.abbreviate", false)).produce()));
        xhtml.addElement(JavascriptPluginInclusion.script(SERVICE_PATH + "address/address-formatter.min.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(SERVICE_PATH + "address/silverpeas-address-commons.js"));
        return xhtml;
    }

    static ElementContainer includeAddressSearch(ElementContainer xhtml, String language) {
        JavascriptPluginInclusion.includeAddressCommons(xhtml, language);
        LocalizationBundle bundle = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.address.multilang.addressBundle", (String)language);
        SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.address.settings.address");
        JavascriptSettingProducer settingBundle = JavascriptSettingProducer.settingVariableName("AddressSearchSettings");
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptBundleProducer.bundleVariableName("AddressSearchBundle").add("a.s.i.t", bundle.getString("address.search.input.title")).add("a.s.i.p", bundle.getString("address.search.input.placeholder")).produce()));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(settingBundle.add("a.s.a.u.b", settings.getString("address.search.api.url.base", "")).add("a.s.a.r.l", settings.getInteger("address.search.api.result.limit", 20)).produce()));
        xhtml.addElement(JavascriptPluginInclusion.script(SERVICE_PATH + "address/silverpeas-address-search-service.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(VUEJS_COMPONENT_PATH + "address/silverpeas-address-search-input.js"));
        return xhtml;
    }

    static ElementContainer includeMap(ElementContainer xhtml, String language) {
        JavascriptPluginInclusion.includeAddressCommons(xhtml, language);
        LocalizationBundle mapBundle = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.map.multilang.mapBundle", (String)language);
        SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.map.settings.map");
        JavascriptSettingProducer settingBundle = JavascriptSettingProducer.settingVariableName("MapSettings");
        String mapDir = URLUtil.getApplicationURL() + "/map/";
        xhtml.addElement(JavascriptPluginInclusion.link(mapDir + "ol/css/ol-min.css"));
        xhtml.addElement(JavascriptPluginInclusion.script(mapDir + "ol/ol-min.js"));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptBundleProducer.bundleVariableName("MapBundle").add("m.f.m", mapBundle.getString("map.fullscreen.mode")).add("m.v.i", mapBundle.getString("map.view.initial")).add("m.z.i", mapBundle.getString("map.zoom.in")).add("m.z.o", mapBundle.getString("map.zoom.out")).produce()));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(settingBundle.add("ip.c.c", JSONCodec.encode((Object)settings.getList("view.infoPoint.category.colors", new String[0], ","))).add("v.f.a.z.max", settings.getInteger("view.fit.auto.zoom.max", 15)).add("v.z.min", settings.getInteger("view.zoom.min", 5)).add("v.z.max", settings.getInteger("view.zoom.max", 20)).add("v.z.d", settings.getInteger("view.zoom.default", 10)).add("v.c.d.lon", Float.valueOf(settings.getFloat("view.coordinates.default.lon", 5.7167f))).add("v.c.d.lat", Float.valueOf(settings.getFloat("view.coordinates.default.lat", 45.1667f))).add("xyz.p", settings.getString("jsonXyzProviders", "")).add("bm.p", settings.getString("jsonBmProvider", "")).add("wmts.c.p", settings.getString("jsonWmtsCapabilityProviders", "")).add("g.d.c", settings.getString("groups.default.color", "#FFF")).add("g.d.o", Float.valueOf(settings.getFloat("groups.default.opacity", 1.0f))).add("g.d.tc", settings.getString("groups.default.textColor", "#000")).add("g.d.tox", settings.getInteger("groups.default.textOffsetX", 0)).add("g.d.toy", settings.getInteger("groups.default.textOffsetY", 0)).add("g.d.ts", Float.valueOf(settings.getFloat("groups.default.textScale", 1.0f))).add("g.d.tfs", settings.getString("groups.default.textFontStyle", "")).add("c.d.e", settings.getBoolean("clusters.default.enabled", false)).add("c.d.r.t", Float.valueOf(settings.getFloat("clusters.default.resolution.threshold", 0.0f))).add("c.d.n.t", settings.getInteger("clusters.default.nb.threshold", 1)).add("c.d.d", settings.getInteger("clusters.default.distance", 40)).add("c.d.c", settings.getString("clusters.default.color", "#000")).add("c.d.o", Float.valueOf(settings.getFloat("clusters.default.opacity", 1.0f))).add("c.d.tc", settings.getString("clusters.default.textColor", "#FFF")).add("c.d.tox", settings.getInteger("clusters.default.textOffsetX", 0)).add("c.d.toy", settings.getInteger("clusters.default.textOffsetY", 0)).add("c.d.ts", Float.valueOf(settings.getFloat("clusters.default.textScale", 1.0f))).add("c.d.tfs", settings.getString("clusters.default.textFontStyle", "")).add("c.d.z.p", settings.getInteger("clusters.default.zoom.padding", 200)).produce()));
        xhtml.addElement(JavascriptPluginInclusion.link(mapDir + "css/silverpeas-map.css"));
        xhtml.addElement(JavascriptPluginInclusion.script(mapDir + "js/services/silverpeas-map-address-service.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(mapDir + "js/services/silverpeas-map-user-service.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(mapDir + "js/silverpeas-map.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(mapDir + "js/silverpeas-map-form.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(mapDir + "js/vuejs/silverpeas-map-common.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(mapDir + "js/vuejs/silverpeas-map-form-common.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(mapDir + "js/vuejs/components/silverpeas-map-common.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(mapDir + "js/vuejs/components/silverpeas-map-form-common.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(mapDir + "js/vuejs/components/silverpeas-map-target-point.js"));
        return xhtml;
    }

    static ElementContainer includeContributionModificationContext(ElementContainer xhtml) {
        String rootDir = URLUtil.getApplicationURL() + "/contribution/jsp/javaScript/";
        JavascriptSettingProducer settingProducer = JavascriptSettingProducer.settingVariableName("ContributionModificationContextSettings");
        settingProducer.add("m.c.e", ContributionSettings.streamComponentNamesWithMinorModificationBehaviorEnabled(), true);
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(settingProducer.produce()));
        xhtml.addElement(JavascriptPluginInclusion.script(rootDir + "silverpeas-contribution-modification-context.js"));
        return xhtml;
    }

    static ElementContainer includeDynamicallySubscription(ElementContainer xhtml, String language) {
        LocalizationBundle bundle = ResourceLocator.getGeneralLocalizationBundle((String)language);
        JavascriptBundleProducer bundleProducer = JavascriptBundleProducer.bundleVariableName("SubscriptionBundle");
        bundleProducer.add("s.s", bundle.getString("GML.subscribe"));
        bundleProducer.add("s.u", bundle.getString("GML.unsubscribe"));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(bundleProducer.produce()));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptPluginInclusion.generatePromise(SupportedWebPlugin.Constants.SUBSCRIPTION, JavascriptPluginInclusion.getDynamicSubscriptionJavascriptLoadContent(RESOLVE_CALLBACK))));
        return xhtml;
    }

    public static String getDynamicSubscriptionJavascriptLoadContent(String jsCallback) {
        String subscriptionLoad = JavascriptPluginInclusion.generateDynamicPluginLoading(JAVASCRIPT_PATH + SILVERPEAS_SUBSCRIPTION, "subscription", "jQuery.subscription.parameters.confirmNotificationSendingOnUpdateEnabled = " + NotificationManagerSettings.isSubscriptionNotificationConfirmationEnabled() + ";", jsCallback);
        JavascriptSettingProducer settingProducer = JavascriptSettingProducer.settingVariableName("SubscriptionSettings");
        settingProducer.add("s.t", SubscriptionFactory.get().streamAll().map(SubscriptionResourceType::getName), true);
        return JavascriptPluginInclusion.getDynamicPopupJavascriptLoadContent(settingProducer.produce() + subscriptionLoad);
    }

    static ElementContainer includeDragAndDropUpload(ElementContainer xhtml, String language) {
        JavascriptPluginInclusion.includeQTip(xhtml, language);
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptBundleProducer.fromCoreTemplate("ddUpload", SILVERPEAS_DRAG_AND_DROP_UPLOAD_I18N_ST, language)));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_DRAG_AND_DROP_UPLOAD));
        JavascriptPluginInclusion.includeIFrameAjaxTransport(xhtml);
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "silverpeas-fileUpload.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + "util/silverpeas-file-upload.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(VUEJS_COMPONENT_PATH + "silverpeas-file-upload.js"));
        return xhtml;
    }

    static ElementContainer includeImageTool(ElementContainer xhtml, String language) {
        JavascriptPluginInclusion.includeDragAndDropUpload(xhtml, language);
        xhtml.addElement(JavascriptPluginInclusion.link(VUEJS_COMPONENT_PATH + "content/image/silverpeas-image-tool.css"));
        xhtml.addElement(JavascriptPluginInclusion.script(VUEJS_COMPONENT_PATH + "content/image/silverpeas-image-tool.js"));
        xhtml.addElement(JavascriptPluginInclusion.link(STYLESHEET_PATH + "jquery.Jcrop.min.css"));
        xhtml.addElement(JavascriptPluginInclusion.script(JQUERY_PATH + "jquery.Jcrop.min.js"));
        return xhtml;
    }

    static ElementContainer includeImageSelector(ElementContainer xhtml, String language) {
        JavascriptPluginInclusion.includeDragAndDropUpload(xhtml, language);
        xhtml.addElement(JavascriptPluginInclusion.script(SERVICE_PATH + "content/silverpeas-image-service.js"));
        xhtml.addElement(JavascriptPluginInclusion.link(VUEJS_COMPONENT_PATH + "content/silverpeas-image-selector.css"));
        xhtml.addElement(JavascriptPluginInclusion.script(VUEJS_COMPONENT_PATH + "content/silverpeas-image-selector.js"));
        return xhtml;
    }

    static ElementContainer includeDocumentTemplate(ElementContainer xhtml) {
        if (DocumentTemplateWebManager.get().existsDocumentTemplate()) {
            JavascriptPluginInclusion.includePreview(xhtml);
            xhtml.addElement(JavascriptPluginInclusion.script(SERVICE_PATH + "content/silverpeas-document-template-service.js"));
            xhtml.addElement(JavascriptPluginInclusion.link(VUEJS_COMPONENT_PATH + "content/silverpeas-document-template.css"));
            xhtml.addElement(JavascriptPluginInclusion.script(VUEJS_COMPONENT_PATH + "content/silverpeas-document-template.js"));
        }
        return xhtml;
    }

    static ElementContainer includeFileManager(ElementContainer xhtml) {
        JavascriptPluginInclusion.includePreview(xhtml);
        JavascriptPluginInclusion.includeDocumentTemplate(xhtml);
        xhtml.addElement(JavascriptPluginInclusion.link(VUEJS_COMPONENT_PATH + "content/silverpeas-file-manager.css"));
        xhtml.addElement(JavascriptPluginInclusion.script(VUEJS_COMPONENT_PATH + "content/silverpeas-file-manager.js"));
        return xhtml;
    }

    static ElementContainer includeBasketSelection(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.script(SERVICE_PATH + "contribution/silverpeas-basket-service.js"));
        xhtml.addElement(JavascriptPluginInclusion.link(VUEJS_COMPONENT_PATH + "contribution/silverpeas-basket-selection.css"));
        xhtml.addElement(JavascriptPluginInclusion.script(VUEJS_COMPONENT_PATH + "contribution/silverpeas-basket-selection.js"));
        return xhtml;
    }

    static ElementContainer includeLayout(ElementContainer xhtml, LookHelper lookHelper) {
        if (lookHelper != null) {
            LayoutConfiguration layout = lookHelper.getLayoutConfiguration();
            JavascriptPluginInclusion.includeQTip(xhtml, lookHelper.getLanguage());
            xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptSettingProducer.settingVariableName("LayoutSettings").add("layout.header.url", URLUtil.getApplicationURL() + layout.getHeaderURL()).add("layout.header.toggle.fade", layout.isHeaderToggleFade()).add("layout.body.url", URLUtil.getApplicationURL() + layout.getBodyURL()).add("layout.body.navigation.url", URLUtil.getApplicationURL() + layout.getBodyNavigationURL()).add("layout.body.navigation.toggle.fade", layout.isBodyNavigationFade()).add("layout.pdc.activated", lookHelper.displayPDCFrame()).add("layout.pdc.baseUrl", URLUtil.getApplicationURL() + "/RpdcSearch/jsp/").add("layout.pdc.action.default", "ChangeSearchTypeToExpert").add("sse.enabled", NotificationManagerSettings.isSseEnabled() && !lookHelper.isAnonymousUser()).add("sse.usingWebSocket", NotificationManagerSettings.usingWebSocket()).produce()));
            xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptSettingProducer.settingVariableName("AdminLayoutSettings").add("layout.header.url", URLUtil.getApplicationURL() + "/RjobManagerPeas/jsp/TopBarManager").add("layout.body.url", "").add("layout.body.navigation.url", "").produce()));
            LocalizationBundle errorBundle = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.common.multilang.errors", (String)lookHelper.getLanguage());
            xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptBundleProducer.bundleVariableName("WindowBundle").add("e.t.r", errorBundle.getString("error.technical.responsive")).produce()));
            xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptSettingProducer.settingVariableName("WindowSettings").add("permalink.parts", PermalinkRegistry.get().streamAllUrlParts(), true).produce()));
            xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptBundleProducer.bundleVariableName("LayoutBundle").add("l.l.r", lookHelper.getString("lookSilverpeasV5.layout.reduce")).add("l.l.e", lookHelper.getString("lookSilverpeasV5.layout.enlarge")).add("l.l.m", lookHelper.getString("lookSilverpeasV5.layout.menu")).add("l.l.h", lookHelper.getString("lookSilverpeasV5.layout.header")).produce()));
            xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "silverpeas-window.js"));
            xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_LAYOUT));
            xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "silverpeas-admin-window.js"));
            xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "silverpeas-admin-layout.js"));
        }
        return xhtml;
    }

    static ElementContainer includeMessager(ElementContainer xhtml, String language) {
        LocalizationBundle notifBundle = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.notificationUser.multilang.notificationUserBundle", (String)language);
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptBundleProducer.bundleVariableName("NotificationBundle").add("send", notifBundle.getString("Envoyer")).add("cancel", notifBundle.getString(CANCEL_BUNDLE_KEY)).add("thefield", notifBundle.getString("GML.thefield")).add("addressees", notifBundle.getString("addressees")).add("title", notifBundle.getString("GML.notification.subject")).add("isRequired", notifBundle.getString("GML.isRequired")).produce()));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "silverpeas-messager.js"));
        return xhtml;
    }

    static ElementContainer includeSelectize(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.link(STYLESHEET_PATH + "selectize.css"));
        xhtml.addElement(JavascriptPluginInclusion.link(STYLESHEET_PATH + "silverpeas-selectize.css"));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "selectize.min.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + "silverpeas-selectize.js"));
        return xhtml;
    }

    static ElementContainer includeListOfUsersAndGroups(ElementContainer xhtml, String language) {
        LocalizationBundle bundle = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.notificationManager.multilang.notificationManagerBundle", (String)language);
        int userManualNotificationUserReceiverLimitValue = 0;
        boolean domainRestricted = false;
        if (User.getCurrentRequester() != null) {
            userManualNotificationUserReceiverLimitValue = User.getCurrentRequester().getUserManualNotificationUserReceiverLimitValue();
            domainRestricted = User.getCurrentRequester().isDomainRestricted();
        }
        JavascriptPluginInclusion.includeSelectize(xhtml);
        JavascriptPluginInclusion.includePopup(xhtml);
        JavascriptPluginInclusion.includeQTip(xhtml, language);
        SettingBundle gefSettings = GraphicElementFactory.getSettings();
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptSettingProducer.settingVariableName("UserGroupListSettings").add("u.m.n.u.r.l.v", userManualNotificationUserReceiverLimitValue).add("d.r", domainRestricted).add("d.nb", OrganizationController.get().getAllDomains().length).add("i.q.m.c", gefSettings.getInteger("input.query.min.chars", 3)).produce()));
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptBundleProducer.bundleVariableName("UserGroupListBundle").add((SilverpeasBundle)ResourceLocator.getGeneralLocalizationBundle((String)language), "GML.user_s", "GML.group_s", "GML.and", "GML.delete", "GML.deleteAll", "GML.action.remove", "GML.action.removeAll", "GML.action.keep", "GML.confirmation.delete", "GML.confirmation.deleteAll", "GML.modify", "GML.action.select", "GML.list.changed.message", "GML.user.account.state.BLOCKED.short", "GML.user.account.state.DEACTIVATED.short", "GML.user.account.state.EXPIRED.short", "GML.user.account.state.DELETED.short").add("n.m.r.l.m.w", bundle.getStringWithParams("notif.manual.receiver.limit.message.warning", new Object[]{userManualNotificationUserReceiverLimitValue})).produce()));
        xhtml.addElement(JavascriptPluginInclusion.script(JAVASCRIPT_PATH + SILVERPEAS_LIST_OF_USERS_AND_GROUPS_JS));
        xhtml.addElement(JavascriptPluginInclusion.script(VUEJS_COMPONENT_PATH + "silverpeas-user-group-select.js"));
        return xhtml;
    }

    static ElementContainer includeCrud(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + "util/silverpeas-crud.js"));
        return xhtml;
    }

    static ElementContainer includePanes(ElementContainer xhtml) {
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + "util/silverpeas-panes.js"));
        return xhtml;
    }

    static ElementContainer includeContributionReminder(ElementContainer xhtml, String language) {
        LocalizationBundle localizedUnits = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.util.multilang.util", (String)language);
        String beforeLabel = " " + localizedUnits.getString("GML.before");
        Pair defaultReminder = ReminderSettings.getDefaultReminder();
        xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptSettingProducer.settingVariableName("ReminderSettings").add("r.p", ReminderSettings.getPossibleReminders().map(r -> JSONCodec.encodeObject(o -> o.put("label", localizedUnits.getStringWithParams(String.valueOf(r.getRight()) + ".precise", new Object[]{r.getLeft()}) + beforeLabel).put("duration", (Integer)r.getLeft()).put("timeUnit", ((TimeUnit)r.getRight()).name()))), false).add("r.d.l", localizedUnits.getStringWithParams(String.valueOf(defaultReminder.getRight()) + ".precise", new Object[]{defaultReminder.getLeft()}) + beforeLabel).produce()));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_DIRECTIVES_PATH + "contribution/silverpeas-contribution-reminder.js"));
        xhtml.addElement(JavascriptPluginInclusion.script(ANGULARJS_SERVICES_PATH + "contribution/silverpeas-contribution-reminder.js"));
        return xhtml;
    }

    static ElementContainer includeVirtualKeyboard(ElementContainer xhtml, String language) {
        SettingBundle generalSettings = ResourceLocator.getGeneralSettingBundle();
        if (generalSettings.getBoolean("web.tool.virtualKeyboard", false)) {
            LocalizationBundle bundle = ResourceLocator.getGeneralLocalizationBundle((String)language);
            xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptBundleProducer.bundleVariableName("VirtualKeyboardBundle").add("vk.a", bundle.getString("GML.virtual.keyboard.activate")).add("vk.d", bundle.getString("GML.virtual.keyboard.deactivate")).produce()));
            xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptSettingProducer.settingVariableName("VirtualKeyboardSettings").add("u.l", language).produce()));
            xhtml.addElement(JavascriptPluginInclusion.link(VIRTUAL_KEYBOARD_PATH + "/vendor/css/simple-keyboard-2.27.1.min.css"));
            xhtml.addElement(JavascriptPluginInclusion.link(VIRTUAL_KEYBOARD_PATH + "/css/silverkeyboard.css"));
            xhtml.addElement(JavascriptPluginInclusion.script(VIRTUAL_KEYBOARD_PATH + "/vendor/js/simple-keyboard-2.27.1.min.js"));
            xhtml.addElement(JavascriptPluginInclusion.script(VIRTUAL_KEYBOARD_PATH + "/vendor/js/layouts/french.min.js"));
            xhtml.addElement(JavascriptPluginInclusion.script(VIRTUAL_KEYBOARD_PATH + "/vendor/js/layouts/english.min.js"));
            xhtml.addElement(JavascriptPluginInclusion.script(VIRTUAL_KEYBOARD_PATH + "/vendor/js/layouts/german.min.js"));
            xhtml.addElement(JavascriptPluginInclusion.script(VIRTUAL_KEYBOARD_PATH + "/js/silverkeyboard.js"));
        }
        return xhtml;
    }

    static ElementContainer includeA11y(ElementContainer xhtml, String language) {
        SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.a11y.settings.a11y");
        if (settings.getBoolean("a11y.enable", false)) {
            LocalizationBundle bundle = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.a11y.multilang.a11yBundle", (String)language);
            xhtml.addElement(JavascriptPluginInclusion.scriptContent(JavascriptBundleProducer.bundleVariableName("A11yBundle").add("a.p.c", bundle.getString("a11y.param.contrast")).add("a.p.c.gl", bundle.getString("a11y.param.contrast.greyLevel")).add("a.p.c.hc", bundle.getString("a11y.param.contrast.highContrast")).add("a.p.c.nhc", bundle.getString("a11y.param.contrast.negativeHighContrast")).add("a.p.f", bundle.getString("a11y.param.font")).add("a.p.f.b", bundle.getString("a11y.param.font.big")).add("a.p.cz", bundle.getString("a11y.param.clickZone")).add("a.p.cz.e", bundle.getString("a11y.param.clickZone.enlarged")).add("a.p.l", bundle.getString("a11y.param.links")).add("a.p.l.u", bundle.getString("a11y.param.links.underlined")).produce()));
            xhtml.addElement(JavascriptPluginInclusion.link(A11Y_PATH + "/css/silverpeas-a11y.css"));
            xhtml.addElement(JavascriptPluginInclusion.link(A11Y_PATH + "/css/silverpeas-a11y-module.css"));
            xhtml.addElement(JavascriptPluginInclusion.script(A11Y_PATH + "/js/silverpeas-a11y.js"));
            xhtml.addElement(JavascriptPluginInclusion.script(A11Y_PATH + "/js/vuejs/components/silverpeas-a11y.js"));
        }
        return xhtml;
    }

    public static String normalizeWebResourceUrl(String url) {
        String normalizedUrl = URLUtil.getMinifiedWebResourceUrl((String)url);
        return URLUtil.addFingerprintVersionOn((String)normalizedUrl);
    }
}

