/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util.viewgenerator.html;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.PageContext;
import org.silverpeas.core.admin.domain.model.Domain;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.i18n.I18NHelper;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.http.HttpRequest;
import org.silverpeas.core.web.mvc.controller.MainSessionController;
import org.silverpeas.core.web.util.viewgenerator.html.WebCommonLookAndFeel;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayPane;
import org.silverpeas.core.web.util.viewgenerator.html.arraypanes.ArrayPaneSilverpeasV5;
import org.silverpeas.core.web.util.viewgenerator.html.board.Board;
import org.silverpeas.core.web.util.viewgenerator.html.board.BoardSilverpeasV5;
import org.silverpeas.core.web.util.viewgenerator.html.browsebars.BrowseBar;
import org.silverpeas.core.web.util.viewgenerator.html.browsebars.BrowseBarComplete;
import org.silverpeas.core.web.util.viewgenerator.html.buttonpanes.ButtonPane;
import org.silverpeas.core.web.util.viewgenerator.html.buttonpanes.ButtonPaneWA2;
import org.silverpeas.core.web.util.viewgenerator.html.buttons.Button;
import org.silverpeas.core.web.util.viewgenerator.html.buttons.ButtonSilverpeasV5;
import org.silverpeas.core.web.util.viewgenerator.html.calendar.Calendar;
import org.silverpeas.core.web.util.viewgenerator.html.calendar.CalendarWA1;
import org.silverpeas.core.web.util.viewgenerator.html.frame.Frame;
import org.silverpeas.core.web.util.viewgenerator.html.frame.FrameSilverpeasV5;
import org.silverpeas.core.web.util.viewgenerator.html.iconpanes.IconPane;
import org.silverpeas.core.web.util.viewgenerator.html.iconpanes.IconPaneWA;
import org.silverpeas.core.web.util.viewgenerator.html.navigationlist.NavigationList;
import org.silverpeas.core.web.util.viewgenerator.html.navigationlist.NavigationListSilverpeasV5;
import org.silverpeas.core.web.util.viewgenerator.html.operationpanes.OperationPane;
import org.silverpeas.core.web.util.viewgenerator.html.operationpanes.OperationPaneSilverpeasV5Web20;
import org.silverpeas.core.web.util.viewgenerator.html.pagination.Pagination;
import org.silverpeas.core.web.util.viewgenerator.html.pagination.PaginationSP;
import org.silverpeas.core.web.util.viewgenerator.html.progressmessage.ProgressMessage;
import org.silverpeas.core.web.util.viewgenerator.html.progressmessage.ProgressMessageSilverpeasV5;
import org.silverpeas.core.web.util.viewgenerator.html.tabs.TabbedPane;
import org.silverpeas.core.web.util.viewgenerator.html.tabs.TabbedPaneSilverpeasV5;
import org.silverpeas.core.web.util.viewgenerator.html.window.Window;
import org.silverpeas.core.web.util.viewgenerator.html.window.WindowWeb20V5;
import org.silverpeas.kernel.bundle.LocalizationBundle;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.cache.model.SimpleCache;
import org.silverpeas.kernel.logging.SilverLogger;

public class GraphicElementFactory
implements Serializable {
    public static final String RESOURCES_KEY = "resources";
    public static final String GE_FACTORY_SESSION_ATT = "SessionGraphicElementFactory";
    private static final SettingBundle settings = ResourceLocator.getSettingBundle((String)"org.silverpeas.util.viewGenerator.settings.graphicElementFactorySettings");
    private static final String ARRAY_PANE = "ArrayPane";
    private static SettingBundle lookSettings;
    private transient SettingBundle favoriteLookSettings = null;
    private static final String REQUEST_SPACE_ID;
    private static final String REQUEST_COMPONENT_ID;
    private static final String REQUEST_IS_COMPONENT_MAIN_PAGE;
    private static final String REQUEST_IS_PORTLET_MAIN_PAGE;
    private static final String REQUEST_EXTERNAL_STYLESHEET;
    private static final String REQUEST_IS_SPACE_HOME_PAGE;
    private static final String ICONS_PATH;
    private transient LocalizationBundle multilang = null;
    private String currentLookName = null;
    private MainSessionController mainSessionController = null;
    public static final String DEFAULT_LOOK_NAME = "Initial";
    static final String MOMENT_JS = "moment-with-locales.min.js";
    static final String MOMENT_TIMEZONE_JS = "moment-timezone-with-data.min.js";
    public static final String STANDARD_CSS = "/util/styleSheets/silverpeas-main.css";

    public GraphicElementFactory(String look) {
        this.setLook(look);
    }

    public GraphicElementFactory(MainSessionController mainSessionController) {
        this.mainSessionController = mainSessionController;
        String userLook = mainSessionController.getFavoriteLook();
        String effectiveLook = this.setLook(userLook);
        if (!userLook.equals(effectiveLook)) {
            mainSessionController.getPersonalization().setLook(effectiveLook);
        }
    }

    public static String getIconsPath() {
        return ICONS_PATH;
    }

    public LocalizationBundle getMultilang() {
        if (this.multilang == null) {
            String language = this.getLanguage();
            this.multilang = ResourceLocator.getLocalizationBundle((String)"org.silverpeas.util.viewGenerator.multilang.graphicElementFactoryBundle", (String)language);
        }
        return this.multilang;
    }

    private String getLanguage() {
        String language = I18NHelper.DEFAULT_LANGUAGE;
        if (this.mainSessionController != null) {
            language = this.mainSessionController.getFavoriteLanguage();
        }
        return language;
    }

    public static SettingBundle getSettings() {
        return settings;
    }

    public SettingBundle getLookSettings() {
        return lookSettings;
    }

    public SettingBundle getFavoriteLookSettings() {
        return this.favoriteLookSettings;
    }

    public final String setLook(String lookName) {
        String aLookName = lookName;
        String look = lookSettings.getString(aLookName, null);
        if (!this.isLookAllowed(aLookName)) {
            aLookName = this.getAvailableLooksForUser().get(0);
            look = lookSettings.getString(aLookName, null);
        }
        this.favoriteLookSettings = ResourceLocator.getSettingBundle((String)look);
        this.currentLookName = aLookName;
        return this.currentLookName;
    }

    private static String getExistingLook() {
        Set lookNames = lookSettings.keySet();
        for (String aLookName : lookNames) {
            if (!GraphicElementFactory.isLookExist(aLookName)) continue;
            return aLookName;
        }
        return DEFAULT_LOOK_NAME;
    }

    private static boolean isLookExist(String lookName) {
        try {
            String selectedLook = lookSettings.getString(lookName);
            SettingBundle look = ResourceLocator.getSettingBundle((String)selectedLook);
            return look.exists();
        }
        catch (MissingResourceException e) {
            SilverLogger.getLogger(GraphicElementFactory.class).error("Look named '" + lookName + "' not found", (Throwable)e);
            return false;
        }
    }

    private boolean isLookAllowed(String lookName) {
        return this.getAvailableLooksForUser().contains(lookName) && GraphicElementFactory.isLookExist(lookName);
    }

    public String getCurrentLookName() {
        return this.currentLookName;
    }

    public static String getCSSOfLook(String lookName) {
        return GraphicElementFactory.getLookSettings(lookName).getString("StyleSheet", null);
    }

    public static SettingBundle getLookSettings(String lookName) {
        String look = lookSettings.getString(lookName, null);
        if (!GraphicElementFactory.isLookExist(lookName)) {
            String existingLookName = GraphicElementFactory.getExistingLook();
            look = lookSettings.getString(existingLookName, null);
        }
        return ResourceLocator.getSettingBundle((String)look);
    }

    public void setExternalStylesheet(String externalStylesheet) {
        CacheAccessorProvider.getThreadCacheAccessor().getCache().put((Object)REQUEST_EXTERNAL_STYLESHEET, (Object)externalStylesheet);
    }

    public String getExternalStylesheet() {
        return (String)CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)REQUEST_EXTERNAL_STYLESHEET, String.class);
    }

    public boolean hasExternalStylesheet() {
        return this.getExternalStylesheet() != null;
    }

    public String getLookFrame() {
        return this.getFavoriteLookSettings().getString("FrameJSP");
    }

    @Deprecated(forRemoval=true)
    public String getLookStyleSheet(HttpRequest request) {
        return WebCommonLookAndFeel.getInstance().getCommonHeader((HttpServletRequest)request);
    }

    public String getIcon(String iconKey) {
        return this.getFavoriteLookSettings().getString(iconKey, null);
    }

    public List<String> getAvailableLooks() {
        SettingBundle theLookSettings = this.getLookSettings();
        return new ArrayList<String>(theLookSettings.keySet());
    }

    public List<String> getAvailableLooksForUser() {
        if (this.getMainSessionController() != null) {
            String domainId = User.getById((String)this.getMainSessionController().getUserId()).getDomainId();
            OrganizationController controller = OrganizationController.get();
            Domain domain = controller.getDomain(domainId);
            List domainLooks = domain.getLooks();
            if (!domainLooks.isEmpty()) {
                return domainLooks;
            }
        }
        return this.getAvailableLooks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Button getFormButton(String label, String action, boolean disabled) {
        Button button = null;
        String buttonClassName = this.getFavoriteLookSettings().getString("Button");
        try {
            button = (Button)Class.forName(buttonClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            button = new ButtonSilverpeasV5();
        }
        finally {
            if (button != null) {
                button.init(label, action, disabled);
            }
        }
        return button;
    }

    public Frame getFrame() {
        Frame frame;
        String frameClassName = this.getFavoriteLookSettings().getString("Frame");
        try {
            frame = (Frame)Class.forName(frameClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            frame = new FrameSilverpeasV5();
        }
        return frame;
    }

    public Board getBoard() {
        Board board;
        String boardClassName = this.getFavoriteLookSettings().getString("Board");
        try {
            board = (Board)Class.forName(boardClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            board = new BoardSilverpeasV5();
        }
        return board;
    }

    public NavigationList getNavigationList() {
        NavigationList navigationList;
        String navigationListClassName = this.getFavoriteLookSettings().getString("NavigationList");
        try {
            navigationList = (NavigationList)Class.forName(navigationListClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            navigationList = new NavigationListSilverpeasV5();
        }
        return navigationList;
    }

    @Deprecated(forRemoval=true)
    public Button getFormButton(String label, String action, boolean disabled, String imagePath) {
        return this.getFormButton(label, action, disabled);
    }

    public TabbedPane getTabbedPane() {
        String tabbedPaneClassName = this.getFavoriteLookSettings().getString("TabbedPane");
        TabbedPane tabbedPane = null;
        try {
            tabbedPane = (TabbedPane)Class.forName(tabbedPaneClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            tabbedPane = new TabbedPaneSilverpeasV5();
        }
        return tabbedPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(forRemoval=true)
    public ArrayPane getArrayPane(String name, PageContext pageContext) {
        String arrayPaneClassName = this.getFavoriteLookSettings().getString(ARRAY_PANE);
        ArrayPane arrayPane = null;
        try {
            arrayPane = (ArrayPane)Class.forName(arrayPaneClassName).newInstance();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            arrayPane = new ArrayPaneSilverpeasV5();
        }
        finally {
            if (arrayPane != null) {
                arrayPane.init(name, pageContext);
            }
        }
        return arrayPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(forRemoval=true)
    public ArrayPane getArrayPane(String name, ServletRequest request, HttpSession session) {
        String arrayPaneClassName = this.getFavoriteLookSettings().getString(ARRAY_PANE);
        ArrayPane arrayPane = null;
        try {
            arrayPane = (ArrayPane)Class.forName(arrayPaneClassName).newInstance();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            arrayPane = new ArrayPaneSilverpeasV5();
        }
        finally {
            if (arrayPane != null) {
                arrayPane.init(name, request, session);
            }
        }
        return arrayPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayPane getArrayPane(String name, String url, ServletRequest request, HttpSession session) {
        String arrayPaneClassName = this.getFavoriteLookSettings().getString(ARRAY_PANE);
        ArrayPane arrayPane = null;
        try {
            arrayPane = (ArrayPane)Class.forName(arrayPaneClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            arrayPane = new ArrayPaneSilverpeasV5();
        }
        finally {
            if (arrayPane != null) {
                arrayPane.init(name, url, request, session);
            }
        }
        return arrayPane;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Window getWindow() {
        String windowClassName = this.getFavoriteLookSettings().getString("Window");
        Window window = null;
        try {
            window = (Window)Class.forName(windowClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            window = new WindowWeb20V5();
        }
        finally {
            if (window != null) {
                window.init(this);
            }
        }
        return window;
    }

    public ButtonPane getButtonPane() {
        String buttonPaneClassName = this.getFavoriteLookSettings().getString("ButtonPane");
        try {
            return (ButtonPane)Class.forName(buttonPaneClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new ButtonPaneWA2();
        }
    }

    public IconPane getIconPane() {
        String iconPaneClassName = this.getFavoriteLookSettings().getString("IconPane");
        try {
            return (IconPane)Class.forName(iconPaneClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            return new IconPaneWA();
        }
    }

    public OperationPane getOperationPane() {
        OperationPane operationPane;
        String operationPaneClassName = this.getFavoriteLookSettings().getString("OperationPane");
        try {
            operationPane = (OperationPane)Class.forName(operationPaneClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            operationPane = new OperationPaneSilverpeasV5Web20();
        }
        operationPane.setMultilang(this.getMultilang());
        return operationPane;
    }

    public BrowseBar getBrowseBar() {
        String browseBarClassName = this.getFavoriteLookSettings().getString("BrowseBar");
        try {
            BrowseBar browseBar = (BrowseBar)Class.forName(browseBarClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            browseBar.setComponentId(this.getComponentIdOfCurrentRequest());
            browseBar.setMainSessionController(this.mainSessionController);
            return browseBar;
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            BrowseBarComplete browseBar = new BrowseBarComplete();
            browseBar.setComponentId(this.getComponentIdOfCurrentRequest());
            browseBar.setMainSessionController(this.mainSessionController);
            return browseBar;
        }
    }

    public Calendar getCalendar(String context, String language, Date date) {
        return new CalendarWA1(context, language, date);
    }

    public Pagination getPagination(int nbItems, int nbItemsPerPage, int firstItemIndex) {
        Pagination pagination = this.getPagination();
        pagination.init(nbItems, nbItemsPerPage, firstItemIndex);
        return pagination;
    }

    public Pagination getPagination() {
        Pagination pagination;
        String paginationClassName = this.getFavoriteLookSettings().getString("Pagination", null);
        if (paginationClassName == null) {
            paginationClassName = "org.silverpeas.core.web.util.viewgenerator.html.pagination.PaginationSP";
        }
        try {
            pagination = (Pagination)Class.forName(paginationClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            pagination = new PaginationSP();
        }
        pagination.setMultilang(this.getMultilang());
        return pagination;
    }

    public ProgressMessage getProgressMessage(List<String> messages) {
        ProgressMessage progress;
        String progressClassName = this.getFavoriteLookSettings().getString("Progress", null);
        if (progressClassName == null) {
            progressClassName = "org.silverpeas.core.web.util.viewgenerator.html.progressmessage.ProgressMessageSilverpeasV5";
        }
        try {
            progress = (ProgressMessage)Class.forName(progressClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            progress = new ProgressMessageSilverpeasV5();
        }
        progress.init(messages);
        progress.setMultilang(this.getMultilang());
        return progress;
    }

    public void setComponentIdForCurrentRequest(String componentId) {
        CacheAccessorProvider.getThreadCacheAccessor().getCache().put((Object)REQUEST_COMPONENT_ID, (Object)componentId);
    }

    public String getComponentIdOfCurrentRequest() {
        return (String)CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)REQUEST_COMPONENT_ID, String.class);
    }

    public MainSessionController getMainSessionController() {
        return this.mainSessionController;
    }

    public void setHttpRequest(HttpRequest request) {
        this.mainSessionController = Optional.ofNullable(request.getSession(false)).map(s -> (MainSessionController)s.getAttribute("SilverSessionController")).orElse(null);
        String requestURI = request.getRequestURI();
        boolean isFromSpaceHomePage = request.getParameterAsBoolean("FromSpaceHomepage");
        boolean isComponentMainPage = requestURI.endsWith("/Main") && !requestURI.endsWith("/jsp/Main") || request.getParameterAsBoolean("ComponentMainPage");
        boolean isPortletMainPage = requestURI.toLowerCase().contains("/portlet");
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        cache.put((Object)REQUEST_IS_SPACE_HOME_PAGE, (Object)isFromSpaceHomePage);
        cache.put((Object)REQUEST_IS_COMPONENT_MAIN_PAGE, (Object)isComponentMainPage);
        cache.put((Object)REQUEST_IS_PORTLET_MAIN_PAGE, (Object)isPortletMainPage);
    }

    public boolean isCurrentRequestFromSpaceHomepage() {
        return Boolean.TRUE.equals(CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)REQUEST_IS_SPACE_HOME_PAGE, Boolean.class));
    }

    public boolean isComponentMainPage() {
        return Boolean.TRUE.equals(CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)REQUEST_IS_COMPONENT_MAIN_PAGE, Boolean.class));
    }

    public boolean isPortletMainPage() {
        return Boolean.TRUE.equals(CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)REQUEST_IS_PORTLET_MAIN_PAGE, Boolean.class));
    }

    public String getSpaceIdOfCurrentRequest() {
        return (String)CacheAccessorProvider.getThreadCacheAccessor().getCache().get((Object)REQUEST_SPACE_ID, String.class);
    }

    public void setSpaceIdForCurrentRequest(String spaceId) {
        CacheAccessorProvider.getThreadCacheAccessor().getCache().put((Object)REQUEST_SPACE_ID, (Object)spaceId);
    }

    public String getDefaultLookName() {
        String userLookStyle;
        try {
            userLookStyle = this.mainSessionController.getPersonalization().getLook();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error(e.getMessage(), (Throwable)e);
            userLookStyle = DEFAULT_LOOK_NAME;
        }
        return userLookStyle;
    }

    static {
        REQUEST_SPACE_ID = String.valueOf(GraphicElementFactory.class) + "_REQUEST_SPACE_ID";
        REQUEST_COMPONENT_ID = String.valueOf(GraphicElementFactory.class) + "_REQUEST_COMPONENT_ID";
        REQUEST_IS_COMPONENT_MAIN_PAGE = String.valueOf(GraphicElementFactory.class) + "_REQUEST_IS_COMPONENT_MAIN_PAGE";
        REQUEST_IS_PORTLET_MAIN_PAGE = String.valueOf(GraphicElementFactory.class) + "_REQUEST_IS_PORTLET_MAIN_PAGE";
        REQUEST_EXTERNAL_STYLESHEET = String.valueOf(GraphicElementFactory.class) + "_REQUEST_EXTERNAL_STYLESHEET";
        REQUEST_IS_SPACE_HOME_PAGE = String.valueOf(GraphicElementFactory.class) + "_REQUEST_IS_SPACE_HOME_PAGE";
        ICONS_PATH = (URLUtil.getApplicationURL() + settings.getString("IconsPath")).replaceAll("/$", "");
        lookSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.util.viewGenerator.settings.lookSettings");
        try {
            lookSettings.getString("dummy", null);
        }
        catch (MissingResourceException e) {
            SilverLogger.getLogger(GraphicElementFactory.class).warn("lookSettings bundle not found. Load then defaultLookSettings bundle", new Object[0]);
            lookSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.util.viewGenerator.settings.defaultLookSettings");
        }
    }
}

