/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.util;

import java.util.List;
import java.util.function.UnaryOperator;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.ecs.Element;
import org.apache.ecs.ElementContainer;
import org.apache.ecs.xhtml.textarea;
import org.silverpeas.core.notification.message.MessageManager;
import org.silverpeas.core.util.JSONCodec;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class IFrameAjaxTransportUtil {
    public static final String X_REQUESTED_WITH = "X-Requested-With";
    public static final String AJAX_IFRAME_TRANSPORT = "IFrame";

    private IFrameAjaxTransportUtil() {
    }

    public static WebApplicationException createWebApplicationExceptionWithJSonErrorInHtmlContainer(WebApplicationException wae) {
        String messageKey = MessageManager.getRegistredKey();
        String errorEntity = StringUtil.isDefined((String)messageKey) ? IFrameAjaxTransportUtil.packJSonObjectWithHtmlContainer(o -> o.put("iframeMessageKey", messageKey)) : IFrameAjaxTransportUtil.packObjectToJSonDataWithHtmlContainer(wae.getResponse().getEntity());
        return new WebApplicationException(Response.status((int)wae.getResponse().getStatus()).type(MediaType.TEXT_HTML_TYPE).entity((Object)errorEntity).build());
    }

    public static String packObjectToJSonDataWithHtmlContainer(Object object) {
        String json = "";
        if (object != null) {
            json = JSONCodec.encode((Object)object);
        }
        return IFrameAjaxTransportUtil.packJSonDataWithHtmlContainer(json);
    }

    public static String packObjectToJSonDataWithHtmlContainer(List<Object> objects) {
        String jsonArray = "";
        if (objects != null && !objects.isEmpty()) {
            jsonArray = JSONCodec.encode(objects);
        }
        return IFrameAjaxTransportUtil.packJSonDataWithHtmlContainer(jsonArray);
    }

    public static String packJSonObjectWithHtmlContainer(UnaryOperator<JSONCodec.JSONObject> jsonObjectBuilder) {
        String json = "";
        if (jsonObjectBuilder != null) {
            try {
                json = JSONCodec.encodeObject(jsonObjectBuilder);
            }
            catch (Exception ex) {
                SilverLogger.getLogger(IFrameAjaxTransportUtil.class).silent((Throwable)ex);
            }
        }
        return IFrameAjaxTransportUtil.packJSonDataWithHtmlContainer(json);
    }

    public static String packJSonArrayWithHtmlContainer(UnaryOperator<JSONCodec.JSONArray> jsonArrayBuilder) {
        String json = "";
        if (jsonArrayBuilder != null) {
            try {
                json = JSONCodec.encodeArray(jsonArrayBuilder);
                if (json.trim().equals("[]")) {
                    json = "";
                }
            }
            catch (Exception ex) {
                SilverLogger.getLogger(IFrameAjaxTransportUtil.class).silent((Throwable)ex);
            }
        }
        return IFrameAjaxTransportUtil.packJSonDataWithHtmlContainer(json);
    }

    protected static String packJSonDataWithHtmlContainer(String jsonString) {
        ElementContainer xhtmlcontainer = new ElementContainer();
        textarea response = new textarea();
        response.addAttribute("data-type", "application/json");
        if (StringUtil.isDefined((String)jsonString)) {
            response.addElementToRegistry(jsonString);
        }
        return xhtmlcontainer.addElement((Element)response).toString();
    }
}

