/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.publication.subscription.bean;

import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.contribution.publication.model.Location;
import org.silverpeas.core.contribution.publication.model.PublicationPath;
import org.silverpeas.core.security.authorization.NodeAccessControl;
import org.silverpeas.core.subscription.Subscription;
import org.silverpeas.core.subscription.SubscriptionResource;
import org.silverpeas.core.web.subscription.bean.AbstractSubscriptionBean;

public class PublicationSubscriptionBean
extends AbstractSubscriptionBean {
    private final PublicationPath path;

    protected PublicationSubscriptionBean(Subscription subscription, PublicationPath path, SilverpeasComponentInstance component, String language) {
        super(subscription, component, language);
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path.format(this.getLanguage());
    }

    @Override
    public String getLink() {
        return this.path.getContribution().getPermalink();
    }

    @Override
    protected boolean isUserCanAccess(String userId, SubscriptionResource resource) {
        Location location = this.path.getLocation();
        return !location.isUndefined() && NodeAccessControl.get().isUserAuthorized(userId, (Object)location);
    }

    @Override
    protected boolean isGroupCanAccess(String groupId, SubscriptionResource resource) {
        Location location = this.path.getLocation();
        return !location.isUndefined() && NodeAccessControl.get().isGroupAuthorized(groupId, (Object)location);
    }
}

