/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.mvc.route;

import java.util.Optional;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.util.URLUtil;
import org.silverpeas.core.web.SilverpeasWebResource;
import org.silverpeas.core.web.mvc.route.AbstractComponentInstanceRoutingMap;
import org.silverpeas.core.web.mvc.route.ComponentInstanceRoutingMap;
import org.silverpeas.core.web.mvc.route.ComponentInstanceRoutingMapProvider;
import org.silverpeas.core.web.mvc.route.DefaultComponentInstanceRoutingMap;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.Mutable;

class DefaultComponentInstanceRoutingMapProvider
implements ComponentInstanceRoutingMapProvider {
    private final String instanceId;
    private final String componentName;
    private AbstractComponentInstanceRoutingMap relativeRoutingMap;
    private AbstractComponentInstanceRoutingMap relativeToSilverpeasRoutingMap;
    private AbstractComponentInstanceRoutingMap absoluteRoutingMap;

    DefaultComponentInstanceRoutingMapProvider(String instanceId) {
        this.instanceId = instanceId;
        this.componentName = SilverpeasComponentInstance.getComponentName((String)instanceId);
    }

    public ComponentInstanceRoutingMap relative() {
        if (this.relativeRoutingMap == null) {
            this.relativeRoutingMap = this.newRoutingMap().init(this.instanceId, "", "/services" + this.getWebResourceBase());
        }
        return this.relativeRoutingMap;
    }

    public ComponentInstanceRoutingMap relativeToSilverpeas() {
        if (this.relativeToSilverpeasRoutingMap == null) {
            this.relativeToSilverpeasRoutingMap = this.newRoutingMap().init(this.instanceId, URLUtil.getApplicationURL(), SilverpeasWebResource.getBasePath() + this.getWebResourceBase());
        }
        return this.relativeToSilverpeasRoutingMap;
    }

    public ComponentInstanceRoutingMap absolute() {
        if (this.absoluteRoutingMap == null) {
            this.absoluteRoutingMap = this.newRoutingMap().init(this.instanceId, URLUtil.getAbsoluteApplicationURL(), SilverpeasWebResource.getAbsoluteBasePath() + this.getWebResourceBase());
        }
        return this.absoluteRoutingMap;
    }

    private String getWebResourceBase() {
        return "/" + Optional.ofNullable(this.componentName).map(String::toLowerCase).orElseGet(this.instanceId::toLowerCase);
    }

    private AbstractComponentInstanceRoutingMap newRoutingMap() {
        Mutable componentRoutingMap = Mutable.empty();
        if (this.componentName != null) {
            try {
                componentRoutingMap.set((Object)((AbstractComponentInstanceRoutingMap)ServiceProvider.getService((String)this.componentName, (String)"InstanceRoutingMap")));
            }
            catch (SilverpeasRuntimeException e) {
                SilverLogger.getLogger(ComponentInstanceRoutingMap.class).silent((Throwable)e);
            }
        }
        return (AbstractComponentInstanceRoutingMap)componentRoutingMap.orElseGet(DefaultComponentInstanceRoutingMap::new);
    }
}

