/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.look;

import java.util.HashMap;
import java.util.Map;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.util.StringUtil;

public class TickerSettings {
    private String label = "";
    private Map<String, String> params = new HashMap<String, String>();
    private boolean linkOnItem = false;
    private int refreshDelay = 60;
    private boolean displayDescription = false;
    private int displayLimit = 10;

    public TickerSettings(SettingBundle settings) {
        for (String key : settings.keySet()) {
            String param;
            if (!key.startsWith("ticker.plugin") || (param = settings.getString(key, null)) == null) continue;
            this.params.put(key.substring(key.lastIndexOf(46) + 1), param);
        }
        this.linkOnItem = settings.getBoolean("ticker.linkOnItem", false);
        this.refreshDelay = settings.getInteger("ticker.autocheck.delay", 60);
        this.displayDescription = settings.getBoolean("ticker.items.description", false);
        this.displayLimit = settings.getInteger("ticker.display.limit", 10);
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public String getParam(String key, String defaultValue) {
        if (!StringUtil.isDefined((String)this.params.get(key))) {
            return defaultValue;
        }
        return this.params.get(key);
    }

    public boolean isLinkOnItem() {
        return this.linkOnItem;
    }

    public int getRefreshDelay() {
        return this.refreshDelay;
    }

    public int getDisplayLimit() {
        return this.displayLimit;
    }

    public boolean isDescriptionDisplayed() {
        return this.displayDescription;
    }
}

