/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.index.components;

import java.lang.annotation.Annotation;
import org.silverpeas.core.admin.component.model.SilverpeasComponentInstance;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.pdc.pdc.service.PdcIndexer;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.web.index.AbstractIndexer;
import org.silverpeas.core.web.index.components.ComponentIndexation;
import org.silverpeas.core.web.index.components.ComponentIndexerAdapter;
import org.silverpeas.core.web.index.tools.PersonalToolIndexation;
import org.silverpeas.kernel.SilverpeasRuntimeException;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public class ApplicationIndexer
extends AbstractIndexer {
    protected ApplicationIndexer() {
    }

    public static ApplicationIndexer getInstance() {
        return (ApplicationIndexer)ServiceProvider.getService(ApplicationIndexer.class, (Annotation[])new Annotation[0]);
    }

    @Override
    protected void indexAllData() {
        this.indexAllSpaces();
        this.indexPersonalComponents();
        this.indexPdc();
        this.indexGroups();
        this.indexUsers();
    }

    public void index(String personalComponent) {
        if (personalComponent != null) {
            this.indexPersonalComponent(personalComponent);
        }
    }

    private void indexComponent(SilverpeasComponentInstance compoInst) {
        SilverLogger.getLogger((Object)this).info("starting indexation of component ''{0}'' with id ''{1}''", new Object[]{compoInst.getLabel(), compoInst.getId()});
        this.admin.indexComponent(compoInst.getId());
        ComponentIndexation componentIndexer = this.getIndexer(compoInst);
        if (componentIndexer != null) {
            try {
                componentIndexer.index(compoInst, !this.isIndexAllProcess());
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error("failure while indexing component ''{0}'' with id ''{1}''", (Object[])new String[]{compoInst.getLabel(), compoInst.getId()}, (Throwable)e);
            }
        }
        SilverLogger.getLogger((Object)this).info("ending indexation of component ''{0}'' with id ''{1}''", new Object[]{compoInst.getLabel(), compoInst.getId()});
    }

    @Override
    public void indexPersonalComponent(String personalComponent) {
        SilverLogger.getLogger((Object)this).info("starting indexation of personal component of type  ''{0}''", new Object[]{personalComponent});
        String compoName = this.firstLetterToLowerCase(personalComponent);
        try {
            PersonalToolIndexation personalToolIndexer = (PersonalToolIndexation)ServiceProvider.getService((String)(compoName + "PersonalToolIndexation"));
            personalToolIndexer.index();
        }
        catch (SilverpeasRuntimeException ce) {
            SilverLogger.getLogger((Object)this).silent((Throwable)ce).warn("cannot get personal component of type ''{0}'' ({1})", new Object[]{personalComponent, ce.getMessage()});
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("failure while indexing personal component of type ''{0}''", (Object[])new String[]{personalComponent}, (Throwable)e);
        }
        SilverLogger.getLogger((Object)this).info("ending indexation of personal component of type  ''{0}''", new Object[]{personalComponent});
    }

    @Override
    public void indexComponent(String spaceId, String componentId) {
        try {
            OrganizationController.get().getComponentInstance(componentId).ifPresent(this::indexComponent);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("failure while indexing component with id ''{0}''", (Object[])new String[]{componentId}, (Throwable)e);
        }
    }

    public void indexPdc() {
        try {
            PdcIndexer indexer = PdcIndexer.getInstance();
            indexer.index();
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("failure while indexing PDC", (Throwable)e);
        }
    }

    private String firstLetterToLowerCase(String str) {
        return StringUtil.uncapitalize((String)str);
    }

    private ComponentIndexation getIndexer(SilverpeasComponentInstance compoInst) {
        ComponentIndexation componentIndexer;
        try {
            String qualifier = compoInst.getName() + "Indexation";
            componentIndexer = (ComponentIndexation)ServiceProvider.getService((String)qualifier);
        }
        catch (SilverpeasRuntimeException ex) {
            SilverLogger.getLogger((Object)this).silent((Throwable)ex).warn("no indexer for component ''{0}'' with id ''{1}'' ({2})", new Object[]{compoInst.getLabel(), compoInst.getId(), ex.getMessage()});
            componentIndexer = (ComponentIndexation)ServiceProvider.getService(ComponentIndexerAdapter.class, (Annotation[])new Annotation[0]);
        }
        return componentIndexer;
    }

    public void indexUsers() {
        SilverLogger.getLogger((Object)this).debug("starting indexation of users", new Object[0]);
        this.admin.indexAllUsers();
        SilverLogger.getLogger((Object)this).debug("ending indexation of users", new Object[0]);
    }

    public void indexGroups() {
        SilverLogger.getLogger((Object)this).debug("starting indexation of groups", new Object[0]);
        this.admin.indexAllGroups();
        SilverLogger.getLogger((Object)this).debug("ending indexation of groups", new Object[0]);
    }
}

