/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.index;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.annotation.Annotation;
import org.silverpeas.core.index.indexing.IndexFileManager;
import org.silverpeas.core.index.indexing.model.DidYouMeanIndexer;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.core.web.index.AbstractIndexer;
import org.silverpeas.core.web.index.tools.FileFilterAgenda;
import org.silverpeas.core.web.index.tools.FileFilterTodo;
import org.silverpeas.kernel.logging.SilverLogger;

public class ApplicationDYMIndexer
extends AbstractIndexer {
    private static final String CONTENT = "content";

    protected ApplicationDYMIndexer() {
    }

    public static ApplicationDYMIndexer getInstance() {
        return (ApplicationDYMIndexer)ServiceProvider.getService(ApplicationDYMIndexer.class, (Annotation[])new Annotation[0]);
    }

    @Override
    protected void indexAllData() {
        this.indexAllSpaces();
        this.indexPersonalComponents();
        this.indexPdc();
    }

    @Override
    public void indexComponent(String spaceId, String componentId) {
        try {
            String componentIndexPath = IndexFileManager.getAbsoluteIndexPath((String)componentId);
            DidYouMeanIndexer.createSpellIndexForAllLanguage((String)CONTENT, (String)componentIndexPath);
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("failure while indexing component with id ''{0}''", (Object[])new String[]{componentId}, (Throwable)e);
        }
    }

    @Override
    public void indexPersonalComponent(String personalComponent) {
        try {
            FilenameFilter filter;
            File file = new File(IndexFileManager.getIndexUpLoadPath());
            if ("agenda".equalsIgnoreCase(personalComponent)) {
                filter = new FileFilterAgenda();
            } else if ("todo".equalsIgnoreCase(personalComponent)) {
                filter = new FileFilterTodo();
            } else {
                SilverLogger.getLogger((Object)this).error("failure while indexing personal component of type ''{0}''", new Object[]{personalComponent});
                return;
            }
            String[] paths = file.list(filter);
            for (String personalComponentName : paths != null ? paths : new String[]{}) {
                String personalComponentIndexPath = IndexFileManager.getAbsoluteIndexPath((String)personalComponentName);
                DidYouMeanIndexer.createSpellIndex((String)CONTENT, (String)personalComponentIndexPath);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("failure while indexing personal component of type ''{0}''", (Object[])new String[]{personalComponent}, (Throwable)e);
        }
    }

    public void indexPdc() {
        SilverLogger.getLogger((Object)this).debug("starting indexation of PDC", new Object[0]);
        String pdcIndexPath = IndexFileManager.getAbsoluteIndexPath((String)"pdc");
        DidYouMeanIndexer.createSpellIndexForAllLanguage((String)CONTENT, (String)pdcIndexPath);
        SilverLogger.getLogger((Object)this).debug("ending indexation of PDC", new Object[0]);
    }
}

