/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.index;

import java.lang.annotation.Annotation;
import org.silverpeas.core.admin.service.AdminController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.index.indexing.model.IndexEngineProxy;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;
import org.silverpeas.kernel.util.StringUtil;

public abstract class AbstractIndexer {
    protected final AdminController admin = (AdminController)ServiceProvider.getService(AdminController.class, (Annotation[])new Annotation[0]);
    private boolean indexAllProcess = false;

    public final void indexAll() {
        this.indexAllProcess = true;
        IndexEngineProxy.removeAllIndexEntries();
        this.indexAllData();
    }

    protected abstract void indexAllData();

    public final void indexAllSpaces() {
        if (!this.isIndexAllProcess()) {
            this.admin.deleteAllSpaceIndexes();
            this.admin.deleteAllComponentIndexes();
        }
        this.index(null, null);
    }

    public void index(String currentSpaceId, String componentId) {
        if (currentSpaceId == null) {
            String[] spaceIds;
            for (String spaceId : spaceIds = OrganizationControllerProvider.getOrganisationController().getAllSpaceIds()) {
                this.indexSpace(spaceId);
            }
        } else if (!StringUtil.isDefined((String)componentId)) {
            this.indexSpace(currentSpaceId);
        } else {
            this.indexComponent(currentSpaceId, componentId);
        }
    }

    private void indexSpace(String spaceId) {
        SilverLogger.getLogger((Object)this).debug("starting space indexation with id ''{0}''", new Object[]{spaceId});
        String currentSpaceId = spaceId;
        try {
            String[] subSpaceIds;
            String[] componentIds;
            if (currentSpaceId.startsWith("WA")) {
                currentSpaceId = currentSpaceId.substring(2);
            }
            this.admin.indexSpace(Integer.parseInt(currentSpaceId));
            for (String componentId : componentIds = OrganizationControllerProvider.getOrganisationController().getAllComponentIds(currentSpaceId)) {
                this.indexComponent(currentSpaceId, componentId);
            }
            for (String subSpaceId : subSpaceIds = OrganizationControllerProvider.getOrganisationController().getAllSubSpaceIds(currentSpaceId)) {
                this.indexSpace(subSpaceId);
            }
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).error("failure while indexing space with id ''{0}''", new Object[]{spaceId}, (Throwable)e);
        }
        SilverLogger.getLogger((Object)this).debug("ending space indexation with id ''{0}''", new Object[]{spaceId});
    }

    protected void indexPersonalComponents() {
        this.indexPersonalComponent("Todo");
    }

    protected boolean isIndexAllProcess() {
        return this.indexAllProcess;
    }

    public abstract void indexComponent(String var1, String var2);

    public abstract void indexPersonalComponent(String var1);
}

