/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication.credentials;

import javax.servlet.http.HttpServletRequest;
import org.silverpeas.core.security.authentication.exception.AuthenticationNoMoreUserConnectionAttemptException;
import org.silverpeas.core.security.authentication.verifier.UserCanTryAgainToLoginVerifier;
import org.silverpeas.core.web.authentication.credentials.CredentialsFunctionHandler;

public abstract class ChangeCredentialFunctionHandler
extends CredentialsFunctionHandler {
    protected String performUrlOnBadCredentialError(HttpServletRequest request, String originalUrl, UserCanTryAgainToLoginVerifier userCanTryAgainToLoginVerifier, String messageBundleKey) {
        try {
            StringBuilder message = new StringBuilder(this.getMultilang().getString(messageBundleKey));
            String url = userCanTryAgainToLoginVerifier.verify().performRequestUrl(request, originalUrl);
            if (userCanTryAgainToLoginVerifier.isActivated()) {
                message.append("<br>");
                message.append(userCanTryAgainToLoginVerifier.getMessage());
            }
            request.setAttribute("message", (Object)message.toString());
            return url;
        }
        catch (AuthenticationNoMoreUserConnectionAttemptException e) {
            return userCanTryAgainToLoginVerifier.getErrorDestination();
        }
    }
}

