/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.web.authentication;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.validation.Assertion;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.admin.service.OrganizationControllerProvider;
import org.silverpeas.core.admin.user.model.UserDetail;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.security.authentication.AuthenticationCredential;
import org.silverpeas.core.socialnetwork.model.ExternalAccount;
import org.silverpeas.core.socialnetwork.model.SocialNetworkID;
import org.silverpeas.core.socialnetwork.service.AccessToken;
import org.silverpeas.core.socialnetwork.service.SocialNetworkService;
import org.silverpeas.core.web.authentication.CredentialEncryption;
import org.silverpeas.core.web.sso.SilverpeasSsoPrincipal;
import org.silverpeas.kernel.bundle.ResourceLocator;
import org.silverpeas.kernel.bundle.SettingBundle;
import org.silverpeas.kernel.cache.model.ExternalCache;
import org.silverpeas.kernel.util.StringUtil;

public class AuthenticationParameters {
    private final SettingBundle authenticationSettings = ResourceLocator.getSettingBundle((String)"org.silverpeas.authentication.settings.authenticationSettings");
    private static final int KEY_MAX_LENGTH = 12;
    private String login;
    private String password;
    private String domainId;
    private String domainIdParam;
    private boolean casMode;
    private SilverpeasSsoPrincipal ssoPrincipal;
    private boolean userByInternalAuthTokenMode;
    private boolean useNewEncryptionMode;
    private boolean secured;
    private boolean socialNetworkMode;
    private AuthenticationCredential credential;

    AuthenticationParameters(HttpServletRequest request) {
        HttpSession session = request.getSession();
        UserDetail userByInternalAuthToken = this.getUserByInternalAuthToken(request);
        this.ssoPrincipal = this.getSSOPrincipal(request);
        this.casMode = this.getCASUser(session) != null;
        this.checkSocialNetworkMode(session);
        String stringKey = this.convert2Alpha(session.getId());
        this.useNewEncryptionMode = StringUtil.isDefined((String)request.getParameter("Var2"));
        this.domainIdParam = request.getParameter("DomainId");
        this.secured = request.isSecure();
        String notTakenIntoAccount = "";
        if (userByInternalAuthToken != null) {
            this.userByInternalAuthTokenMode = true;
            this.login = userByInternalAuthToken.getLogin();
            this.domainId = userByInternalAuthToken.getDomainId();
            this.password = "";
        } else if (this.ssoPrincipal != null) {
            this.login = this.ssoPrincipal.getLogin();
            this.password = "";
        } else if (this.casMode) {
            this.login = this.getCASUser(session);
            this.password = "";
        } else if (!this.socialNetworkMode) {
            if (this.useNewEncryptionMode) {
                this.login = request.getParameter("Var2");
                this.password = request.getParameter("Password");
            } else {
                this.login = request.getParameter("Login");
                this.password = request.getParameter("Password");
            }
        }
        this.decodeLogin(stringKey, this.useNewEncryptionMode);
    }

    public void setCredential(AuthenticationCredential credential) {
        this.credential = credential;
    }

    public AuthenticationCredential getCredential() {
        return this.credential;
    }

    public boolean isNewEncryptionMode() {
        return this.useNewEncryptionMode;
    }

    public boolean isSecuredAccess() {
        return this.secured;
    }

    public String getLogin() {
        return this.login;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isCasMode() {
        return this.casMode;
    }

    public boolean isSsoMode() {
        return this.ssoPrincipal != null;
    }

    public boolean isUserByInternalAuthTokenMode() {
        return this.userByInternalAuthTokenMode;
    }

    public boolean isSocialNetworkMode() {
        return this.socialNetworkMode;
    }

    public String getDomainId() {
        if (this.isUserByInternalAuthTokenMode() || this.isSocialNetworkMode()) {
            return this.domainId;
        }
        if (this.isSsoMode()) {
            return this.ssoPrincipal.getDomainId();
        }
        if (this.isCasMode()) {
            return this.authenticationSettings.getString("cas.authentication.domainId", "0");
        }
        OrganizationController controller = OrganizationControllerProvider.getOrganisationController();
        return controller.getDomain(this.domainIdParam).getId();
    }

    private void checkSocialNetworkMode(HttpSession session) {
        this.socialNetworkMode = false;
        SocialNetworkID networkId = SocialNetworkService.getInstance().getSocialNetworkIDUsedForLogin(session);
        if (networkId != null) {
            AccessToken authorizationToken = SocialNetworkService.getInstance().getStoredAuthorizationToken(session, networkId);
            String profileId = SocialNetworkService.getInstance().getSocialNetworkConnector(networkId).getUserProfileId(authorizationToken);
            ExternalAccount account = SocialNetworkService.getInstance().getExternalAccount(networkId, profileId);
            UserDetail user = (UserDetail)OrganizationControllerProvider.getOrganisationController().getUserDetail(account.getSilverpeasUserId());
            this.domainId = user.getDomainId();
            this.login = user.getLogin();
            this.socialNetworkMode = true;
        }
    }

    private void decodeLogin(String stringKey, boolean newEncryptMode) {
        CredentialEncryption encryption = CredentialEncryption.getInstance();
        this.login = newEncryptMode ? encryption.decode(this.login, stringKey, false) : this.login;
    }

    private String convert2Alpha(String toConvert) {
        StringBuilder alphaString = new StringBuilder();
        String convertInUpperCase = toConvert.toUpperCase();
        for (int i = 0; i < toConvert.length() && alphaString.length() < 12; ++i) {
            char asciiCode = convertInUpperCase.charAt(i);
            if (asciiCode < 'A' || asciiCode > 'Z') continue;
            alphaString.append(toConvert.charAt(i));
        }
        if (alphaString.length() < 12) {
            alphaString.append("ZFGHZSZHHJNT".substring(0, 12 - alphaString.length()));
        }
        return alphaString.toString();
    }

    private String getCASUser(HttpSession session) {
        String casUser = null;
        if (session.getAttribute("_const_cas_assertion_") != null) {
            casUser = ((Assertion)session.getAttribute("_const_cas_assertion_")).getPrincipal().getName();
        }
        return casUser;
    }

    private SilverpeasSsoPrincipal getSSOPrincipal(HttpServletRequest request) {
        if (request.getUserPrincipal() instanceof SilverpeasSsoPrincipal) {
            return (SilverpeasSsoPrincipal)request.getUserPrincipal();
        }
        return null;
    }

    private UserDetail getUserByInternalAuthToken(HttpServletRequest request) {
        ExternalCache cache;
        String internalAuthToken = (String)request.getAttribute("internalAuthToken");
        if (StringUtil.isDefined((String)internalAuthToken) && (cache = CacheAccessorProvider.getApplicationCacheAccessor().getCache()).get((Object)internalAuthToken) instanceof UserDetail) {
            return (UserDetail)cache.remove((Object)internalAuthToken);
        }
        return null;
    }
}

