/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.user;

import java.util.Objects;
import org.silverpeas.core.annotation.Service;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.workflow.api.user.Replacement;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.core.workflow.engine.user.ReplacementImpl;
import org.silverpeas.kernel.util.StringUtil;

@Service
public class ReplacementConstructor
implements Replacement.Constructor {
    private ReplacementImpl replacement;

    @Override
    public Replacement.Constructor between(User incumbent, User substitute) {
        this.replacement = new ReplacementImpl().setIncumbent(incumbent).setSubstitute(substitute);
        return this;
    }

    @Override
    public Replacement.Constructor inWorkflow(String workflowInstanceId) {
        this.replacement.setWorkflowId(workflowInstanceId);
        return this;
    }

    public ReplacementImpl during(Period period) {
        Objects.requireNonNull(this.replacement.getIncumbent(), "The incumbent in a replacement must be defined");
        Objects.requireNonNull(this.replacement.getSubstitute(), "The substitute in a replacement must be defined");
        StringUtil.requireDefined((String)this.replacement.getWorkflowInstanceId(), (String)"The workflow instance in a replacement must be defined");
        return this.replacement.setPeriod(period);
    }
}

