/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.notification;

import java.time.LocalDate;
import java.time.temporal.Temporal;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.date.TemporalConverter;
import org.silverpeas.core.notification.system.CDIAfterSuccessfulTransactionResourceEventListener;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.workflow.api.user.Replacement;
import org.silverpeas.core.workflow.engine.notification.ToIncumbentReplacementNotificationBuilder;
import org.silverpeas.core.workflow.engine.notification.ToSubstituteReplacementNotificationBuilder;
import org.silverpeas.core.workflow.engine.user.ReplacementEvent;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
public class ReplacementNotifier
extends CDIAfterSuccessfulTransactionResourceEventListener<ReplacementEvent> {
    public void onDeletion(ReplacementEvent event) {
        Replacement replacement = (Replacement)((Object)event.getTransition().getBefore());
        this.notifyUsersIfEndInFuture(NotifAction.DELETE, replacement);
    }

    public void onUpdate(ReplacementEvent event) {
        Replacement replacement;
        Replacement previous = (Replacement)((Object)event.getTransition().getBefore());
        if (!previous.isSameAs(replacement = (Replacement)((Object)event.getTransition().getAfter()))) {
            if (!replacement.getSubstitute().getUserId().equals(previous.getSubstitute().getUserId())) {
                this.notifyUsersIfEndInFuture(NotifAction.DELETE, previous);
                this.notifyUsersIfEndInFuture(NotifAction.CREATE, replacement);
            } else {
                this.notifyUsers(NotifAction.UPDATE, replacement);
            }
        }
    }

    public void onCreation(ReplacementEvent event) {
        Replacement replacement = (Replacement)((Object)event.getTransition().getAfter());
        this.notifyUsersIfEndInFuture(NotifAction.CREATE, replacement);
    }

    private void notifyUsersIfEndInFuture(NotifAction action, Replacement<?> replacement) {
        LocalDate endDate;
        LocalDate now = LocalDate.now();
        if (now.isBefore(endDate = TemporalConverter.asLocalDate((Temporal)replacement.getPeriod().getEndDate()).minusDays(1L)) || now.equals(endDate)) {
            this.notifyUsers(action, replacement);
        }
    }

    private void notifyUsers(NotifAction action, Replacement<?> replacement) {
        User currentRequester = User.getCurrentRequester();
        if (!currentRequester.getId().equals(replacement.getIncumbent().getUserId())) {
            new ToIncumbentReplacementNotificationBuilder(replacement, action).build().send();
        }
        if (!currentRequester.getId().equals(replacement.getSubstitute().getUserId())) {
            new ToSubstituteReplacementNotificationBuilder(replacement, action).build().send();
        }
    }
}

