/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.model;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.workflow.api.model.ContextualDesignation;
import org.silverpeas.core.workflow.api.model.ContextualDesignations;
import org.silverpeas.core.workflow.engine.model.SpecificLabel;

@XmlRootElement
public class SpecificLabelListHelper
implements ContextualDesignations,
Serializable {
    private static final long serialVersionUID = -4580671511307866063L;
    private static final String DEFAULT = "default";
    @XmlElement(type=SpecificLabel.class)
    private List<ContextualDesignation> labels;

    public SpecificLabelListHelper(List<ContextualDesignation> labels) {
        this.labels = labels;
    }

    @Override
    public String getLabel(String role, String language) {
        ContextualDesignation label = this.getSpecificLabel(role, language);
        if (label != null) {
            return label.getContent();
        }
        label = this.getSpecificLabel(role, DEFAULT);
        if (label != null) {
            return label.getContent();
        }
        label = this.getSpecificLabel(DEFAULT, language);
        if (label != null) {
            return label.getContent();
        }
        label = this.getSpecificLabel(DEFAULT, DEFAULT);
        if (label != null) {
            return label.getContent();
        }
        return "";
    }

    @Override
    public ContextualDesignation getSpecificLabel(String role, String language) {
        for (ContextualDesignation contextualDesignation : this.labels) {
            SpecificLabel label = (SpecificLabel)contextualDesignation;
            if (role == null || !role.equals(label.getRole()) || language == null || !language.equals(label.getLanguage())) continue;
            return label;
        }
        return null;
    }

    @Override
    public void addContextualDesignation(ContextualDesignation contextualDesignation) {
        this.labels.add(contextualDesignation);
    }

    @Override
    public ContextualDesignation createContextualDesignation() {
        return new SpecificLabel();
    }

    @Override
    public Iterator<ContextualDesignation> iterateContextualDesignation() {
        if (this.labels == null) {
            return null;
        }
        return this.labels.iterator();
    }

    @Override
    public void removeContextualDesignation(ContextualDesignation contextualDesignation) {
        if (this.labels == null) {
            return;
        }
        this.labels.removeIf(d -> d.getRole().equals(contextualDesignation.getRole()) && d.getLanguage().equals(contextualDesignation.getLanguage()));
    }
}

