/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlRootElement;
import org.silverpeas.core.workflow.api.model.Action;
import org.silverpeas.core.workflow.api.model.Consequences;
import org.silverpeas.core.workflow.api.model.ContextualDesignation;
import org.silverpeas.core.workflow.api.model.ContextualDesignations;
import org.silverpeas.core.workflow.api.model.Form;
import org.silverpeas.core.workflow.api.model.QualifiedUsers;
import org.silverpeas.core.workflow.engine.model.ConsequencesImpl;
import org.silverpeas.core.workflow.engine.model.FormImpl;
import org.silverpeas.core.workflow.engine.model.QualifiedUsersImpl;
import org.silverpeas.core.workflow.engine.model.SpecificLabel;
import org.silverpeas.core.workflow.engine.model.SpecificLabelListHelper;

@XmlRootElement(name="action")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ActionImpl
implements Action {
    private static final long serialVersionUID = -6984785710903135661L;
    @XmlID
    @XmlAttribute
    private String name;
    @XmlAttribute
    private String kind;
    @XmlElement(name="label", type=SpecificLabel.class)
    private List<ContextualDesignation> labels;
    @XmlElement(name="description", type=SpecificLabel.class)
    private List<ContextualDesignation> descriptions;
    @XmlElement(type=QualifiedUsersImpl.class)
    private QualifiedUsers allowedUsers;
    @XmlIDREF
    @XmlAttribute
    private FormImpl form;
    @XmlElement(type=ConsequencesImpl.class)
    private Consequences consequences;

    public ActionImpl() {
        this.reset();
    }

    private void reset() {
        this.labels = new ArrayList<ContextualDesignation>();
        this.descriptions = new ArrayList<ContextualDesignation>();
        this.kind = "update";
    }

    @Override
    public ContextualDesignations getLabels() {
        return new SpecificLabelListHelper(this.labels);
    }

    @Override
    public String getLabel(String role, String language) {
        return this.getLabels().getLabel(role, language);
    }

    @Override
    public QualifiedUsers getAllowedUsers() {
        return this.allowedUsers;
    }

    @Override
    public Consequences getConsequences() {
        return this.consequences;
    }

    @Override
    public Form getForm() {
        return this.form;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public ContextualDesignations getDescriptions() {
        return new SpecificLabelListHelper(this.descriptions);
    }

    @Override
    public String getDescription(String role, String language) {
        return this.getDescriptions().getLabel(role, language);
    }

    @Override
    public void setAllowedUsers(QualifiedUsers allowedUsers) {
        this.allowedUsers = allowedUsers;
    }

    @Override
    public Consequences createConsequences() {
        return new ConsequencesImpl();
    }

    @Override
    public void setConsequences(Consequences consequences) {
        this.consequences = consequences;
    }

    @Override
    public void setForm(Form form) {
        this.form = (FormImpl)form;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setKind(String kind) {
        this.kind = kind;
    }

    public String getKey() {
        return this.getName();
    }
}

