/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.datarecord;

import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.workflow.api.Workflow;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.api.model.ProcessModel;
import org.silverpeas.core.workflow.api.model.State;
import org.silverpeas.core.workflow.engine.datarecord.ProcessInstanceFieldTemplate;
import org.silverpeas.core.workflow.engine.datarecord.TextRoField;

public class StateTemplate
extends ProcessInstanceFieldTemplate {
    private final ProcessModel processModel;
    private final String role;
    private final String lang;

    public StateTemplate(String fieldName, ProcessModel processModel, String role, String lang) {
        super(fieldName, "text", "text", Workflow.getLabel("stateFieldLabel", lang));
        this.processModel = processModel;
        this.role = role;
        this.lang = lang;
    }

    @Override
    public Field getField(ProcessInstance instance) {
        String[] stateNames;
        StringBuilder stateLabels = new StringBuilder();
        for (String stateName : stateNames = instance.getActiveStates()) {
            State state = this.processModel.getState(stateName);
            if (state == null) continue;
            if (stateLabels.length() > 0) {
                stateLabels.append(" - ");
            }
            stateLabels.append(state.getLabel(this.role, this.lang));
        }
        return new TextRoField(stateLabels.toString());
    }
}

