/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.engine.datarecord;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.silverpeas.core.contribution.content.form.Field;
import org.silverpeas.core.contribution.content.form.FormException;
import org.silverpeas.core.contribution.content.form.FormFatalException;
import org.silverpeas.core.contribution.content.form.TypeManager;
import org.silverpeas.core.contribution.content.form.field.TextFieldImpl;
import org.silverpeas.core.contribution.content.form.record.GenericRecordSetManager;
import org.silverpeas.core.workflow.api.Workflow;
import org.silverpeas.core.workflow.api.WorkflowException;
import org.silverpeas.core.workflow.api.instance.HistoryStep;
import org.silverpeas.core.workflow.api.instance.ProcessInstance;
import org.silverpeas.core.workflow.api.model.Action;
import org.silverpeas.core.workflow.api.model.Item;
import org.silverpeas.core.workflow.api.user.User;
import org.silverpeas.core.workflow.api.user.UserInfo;
import org.silverpeas.core.workflow.api.user.UserSettings;
import org.silverpeas.core.workflow.engine.datarecord.AbstractProcessInstanceDataRecord;
import org.silverpeas.core.workflow.engine.datarecord.DateRoField;
import org.silverpeas.core.workflow.engine.datarecord.ProcessInstanceTemplate;
import org.silverpeas.core.workflow.engine.datarecord.TextRoField;
import org.silverpeas.core.workflow.engine.user.UserSettingsService;
import org.silverpeas.kernel.SilverpeasRuntimeException;

public class LazyProcessInstanceDataRecord
extends AbstractProcessInstanceDataRecord {
    private static final long serialVersionUID = 1L;
    private static final String ACTOR = ".actor.";
    private final String role;
    private final String lang;
    private final Map<String, String> rawValues = new HashMap<String, String>();

    public LazyProcessInstanceDataRecord(ProcessInstance instance, String role, String lang) throws WorkflowException {
        super(instance, role, lang);
        this.role = role;
        this.lang = lang;
    }

    @Override
    protected ProcessInstanceTemplate getTemplate(String role, String lang) {
        return null;
    }

    @Override
    public String getId() {
        return this.instance.getInstanceId();
    }

    @Override
    public Field getField(String fieldName) throws FormException {
        if (fieldName.startsWith("folder.") || fieldName.startsWith("instance.")) {
            int pos = fieldName.indexOf(46);
            return this.getFolderField(fieldName.substring(pos + 1));
        }
        if (fieldName.startsWith("action.")) {
            int pos = fieldName.indexOf(46);
            return this.getActionField(fieldName.substring(pos + 1));
        }
        return null;
    }

    private Field getActionField(String fieldName) throws FormException {
        try {
            if (fieldName.indexOf(46) == -1) {
                TextFieldImpl field = new TextFieldImpl();
                Action action = this.instance.getProcessModel().getAction(fieldName);
                field.setStringValue(action.getLabel(this.role, this.lang));
                return field;
            }
            if (fieldName.endsWith(".label")) {
                return this.getLabelRoField(fieldName);
            }
            if (fieldName.endsWith(".date")) {
                return this.getDateRoField(fieldName);
            }
            if (fieldName.endsWith(".actor")) {
                return this.getActorNameRoField(fieldName);
            }
            if (fieldName.contains(ACTOR)) {
                return this.getRelationRoField(fieldName);
            }
            throw new FormFatalException("Field {0} not found", new String[]{fieldName});
        }
        catch (Exception e) {
            throw new FormFatalException((Throwable)e);
        }
    }

    private Field getLabelRoField(String fieldName) throws WorkflowException, FormException {
        TextFieldImpl field = new TextFieldImpl();
        String actionName = fieldName.substring(0, fieldName.length() - 6);
        Action action = this.instance.getProcessModel().getAction(actionName);
        field.setStringValue(action.getLabel(this.role, this.lang));
        return field;
    }

    private Field getRelationRoField(String fieldName) throws WorkflowException, FormException {
        int fieldIndex = fieldName.indexOf(ACTOR);
        String actionName = fieldName.substring(0, fieldIndex);
        String shortFieldName = fieldName.substring(fieldIndex + 7);
        HistoryStep step = this.instance.getMostRecentStep(actionName);
        Item item = this.instance.getProcessModel().getUserInfos().getItem(shortFieldName);
        if (step != null && item != null) {
            if (item.getMapTo() != null && !item.getMapTo().isEmpty()) {
                User user = Workflow.getUserManager().getUser(step.getUser().getUserId());
                TextFieldImpl field = new TextFieldImpl();
                if (user != null) {
                    field.setStringValue(user.getInfo(item.getMapTo()));
                }
                return field;
            }
            UserSettings settings = UserSettingsService.get().get(step.getUser().getUserId(), this.instance.getModelId());
            UserInfo info = settings.getUserInfo(shortFieldName);
            Field field = this.instance.getProcessModel().getUserInfos().toRecordTemplate(this.role, this.lang, false).getEmptyRecord().getField(shortFieldName);
            if (field != null && info != null) {
                field.setStringValue(info.getValue());
            }
            return field;
        }
        return new TextRoField(null);
    }

    private Field getActorNameRoField(String fieldName) throws WorkflowException {
        String actionName = fieldName.substring(0, fieldName.length() - 6);
        HistoryStep step = this.instance.getMostRecentStep(actionName);
        if (step != null) {
            return new TextRoField(step.getUser().getFullName());
        }
        return new TextRoField(null);
    }

    private Field getDateRoField(String fieldName) {
        String actionName = fieldName.substring(0, fieldName.length() - 5);
        HistoryStep step = this.instance.getMostRecentStep(actionName);
        if (step != null) {
            return new DateRoField(step.getActionDate());
        }
        return new DateRoField(null);
    }

    private Field getFolderField(String fieldName) throws FormException {
        try {
            Item fieldItem = this.instance.getProcessModel().getDataFolder().getItem(fieldName);
            Class fieldImpl = TypeManager.getInstance().getFieldImplementation(fieldItem.getType());
            Class[] noParameterClass = new Class[]{};
            Constructor constructor = fieldImpl.getConstructor(noParameterClass);
            Object[] noParameter = new Object[]{};
            Field field = (Field)constructor.newInstance(noParameter);
            field.setStringValue(this.getFieldValue(fieldName));
            return field;
        }
        catch (Exception e) {
            throw new FormFatalException((Throwable)e);
        }
    }

    private String getFieldValue(String fieldName) {
        return this.rawValues.computeIfAbsent(fieldName, k -> {
            try {
                String folderRecordSetName = this.instance.getProcessModel().getFolderRecordSetName();
                return GenericRecordSetManager.getInstance().getRawValue(folderRecordSetName, this.instance.getInstanceId(), fieldName);
            }
            catch (Exception e) {
                throw new SilverpeasRuntimeException((Throwable)e);
            }
        });
    }

    @Override
    public Field getField(int fieldIndex) {
        return null;
    }

    @Override
    public int size() {
        return -1;
    }
}

