/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.workflow.api.user;

import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.silverpeas.core.admin.service.OrganizationController;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.core.util.stream.StreamWrapper;
import org.silverpeas.core.workflow.api.user.Replacement;
import org.silverpeas.core.workflow.api.user.User;

public class ReplacementList<T extends Replacement<T>>
extends ArrayList<T> {
    private static final long serialVersionUID = 7833770055928190293L;
    private final Map<String, List<String>> userRoleCache;

    ReplacementList(List<T> source) {
        super(source);
        this.userRoleCache = new ConcurrentHashMap<String, List<String>>(source.size());
    }

    @Override
    public FilterStream<T> stream() {
        return new FilterStream(super.stream());
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public class FilterStream<R extends Replacement>
    extends StreamWrapper<R> {
        FilterStream(Stream<R> stream) {
            super(stream);
        }

        public FilterStream<R> filterCurrentAt(Temporal temporal) {
            return new FilterStream<Replacement>(super.stream().filter(r -> r.getPeriod().includes(temporal)));
        }

        public FilterStream<R> filterCurrentAndNextAt(Temporal temporal) {
            return new FilterStream<Replacement>(super.stream().filter(r -> r.getPeriod().endsAfter(temporal)));
        }

        public FilterStream<R> filterOnAtLeastOneRole(String ... roles) {
            return this.filterOnAtLeastOneRole(Arrays.asList(roles));
        }

        public FilterStream<R> filterOnAtLeastOneRole(List<String> roles) {
            Stream<Replacement> newStream = super.stream().filter(r -> {
                List<String> substituteRoles;
                List<String> incumbentRoles = this.getUserRoles(r.getIncumbent(), r.getWorkflowInstanceId());
                List commonRoles = CollectionUtil.intersection(incumbentRoles, substituteRoles = this.getUserRoles(r.getSubstitute(), r.getWorkflowInstanceId()));
                return !CollectionUtil.intersection((List)roles, (List)commonRoles).isEmpty();
            });
            return new FilterStream<Replacement>(newStream);
        }

        public FilterStream<R> filterOnIncumbent(String ... incumbentIds) {
            return this.filterOnIncumbent(Arrays.asList(incumbentIds));
        }

        public FilterStream<R> filterOnIncumbent(List<String> incumbentIds) {
            return new FilterStream<Replacement>(super.stream().filter(r -> incumbentIds.contains(r.getIncumbent().getUserId())));
        }

        private List<String> getUserRoles(User user, String workflowInstanceId) {
            return ReplacementList.this.userRoleCache.computeIfAbsent(user.getUserId(), i -> Arrays.asList(OrganizationController.get().getUserProfiles(user.getUserId(), workflowInstanceId)));
        }
    }
}

