/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PlsqlIbtBindInfo;
import oracle.jdbc.driver.Representation;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

class PlsqlIndexTableAccessor
extends Accessor {
    static final int MAXLENGTH = -1;
    PlsqlIbtBindInfo ibtBindInfo;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:09:24_PDT_2013";
    public static final boolean TRACE = false;

    PlsqlIndexTableAccessor(OracleStatement oracleStatement, PlsqlIbtBindInfo plsqlIbtBindInfo, short s2) throws SQLException {
        super(Representation.PLSQL_INDEX_TABLE, oracleStatement, -1, true);
        this.init(oracleStatement, 998, 998, s2, true);
        this.ibtBindInfo = plsqlIbtBindInfo;
    }

    @Override
    void initForDataAccess(int n2, int n3, String string) throws SQLException {
        this.unimpl("initForDataAccess");
    }

    @Override
    PlsqlIbtBindInfo plsqlIndexTableBindInfo() throws SQLException {
        return this.ibtBindInfo;
    }

    Object[] getPlsqlIndexTable(int n2) throws SQLException {
        Object[] objectArray;
        this.rowData.setPosition(this.getOffset(n2));
        int n3 = this.rowData.getInt();
        switch (this.ibtBindInfo.element_internal_type) {
            case 9: {
                objectArray = new String[n3];
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = this.rowData.getShort();
                    objectArray[i2] = n4 == 0 ? null : this.rowData.getString(n4, this.statement.connection.conversion.getCharacterSet((short)1));
                }
                break;
            }
            case 6: {
                objectArray = new BigDecimal[n3];
                for (int i3 = 0; i3 < n3; ++i3) {
                    int n5 = this.rowData.getShort();
                    objectArray[i3] = n5 == 0 ? null : oracle.sql.NUMBER.toBigDecimal(this.rowData.getBytes(n5));
                }
                break;
            }
            default: {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        assert (this.rowData.getPosition() == this.getOffset(n2) + (long)this.getLength(n2)) : "rowData.position(): " + this.rowData.getPosition() + " getOffset(" + n2 + "): " + this.getOffset(n2) + " getLength(" + n2 + "): " + this.getLength(n2);
        return objectArray;
    }

    @Override
    Datum[] getOraclePlsqlIndexTable(int n2) throws SQLException {
        this.rowData.setPosition(this.getOffset(n2));
        Datum[] datumArray = null;
        int n3 = this.rowData.getInt();
        switch (this.ibtBindInfo.element_internal_type) {
            case 9: {
                datumArray = new CHAR[n3];
                CharacterSet characterSet = this.statement.connection.conversion.getDriverCharSetObj();
                for (int i2 = 0; i2 < n3; ++i2) {
                    int n4 = this.rowData.getShort();
                    datumArray[i2] = n4 == 0 ? null : new CHAR(this.rowData.getBytes(n4), characterSet);
                }
                break;
            }
            case 6: {
                datumArray = new NUMBER[n3];
                for (int i3 = 0; i3 < n3; ++i3) {
                    int n5 = this.rowData.getShort();
                    datumArray[i3] = n5 == 0 ? null : new NUMBER(this.rowData.getBytes(n5));
                }
                break;
            }
            default: {
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        assert (this.rowData.getPosition() == this.getOffset(n2) + (long)this.getLength(n2)) : "rowData.position(): " + this.rowData.getPosition() + " getOffset(" + n2 + "): " + this.getOffset(n2) + " getLength(" + n2 + "): " + this.getLength(n2);
        return datumArray;
    }
}

