/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.util.memory;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.EnumSet;
import org.silverpeas.core.util.memory.MemoryUnit;

public class MemoryData {
    private final BigDecimal byteSize;

    public MemoryData(long byteSize) {
        this.byteSize = new BigDecimal(String.valueOf(byteSize));
    }

    public MemoryData(BigDecimal byteSize) {
        this.byteSize = byteSize;
    }

    public static BigDecimal convertTo(BigDecimal value, MemoryUnit from, MemoryUnit to) {
        int toPower;
        int fromPower = from.getPower();
        int offsetPower = fromPower - (toPower = to.getPower());
        if (offsetPower > 0) {
            return value.multiply(MemoryUnit.byteMultiplier.pow(Math.abs(offsetPower)));
        }
        if (offsetPower < 0) {
            return value.divide(MemoryUnit.byteMultiplier.pow(Math.abs(offsetPower)), 25, 1);
        }
        return value;
    }

    public BigDecimal getSize() {
        return this.getSizeConverted(MemoryUnit.B);
    }

    public Long getSizeAsLong() {
        return this.getSize().longValue();
    }

    public BigDecimal getRoundedSizeConverted(MemoryUnit to) {
        BigDecimal convertedSize = this.getSizeConverted(to);
        int nbMaximumFractionDigits = 2;
        if (EnumSet.of(MemoryUnit.B, MemoryUnit.KB).contains((Object)to)) {
            nbMaximumFractionDigits = 0;
        }
        return convertedSize.setScale(nbMaximumFractionDigits, 1);
    }

    public BigDecimal getSizeConverted(MemoryUnit to) {
        return MemoryData.convertTo(this.byteSize, MemoryUnit.B, to);
    }

    public MemoryUnit getBestUnit() {
        MemoryUnit to = MemoryUnit.values()[MemoryUnit.values().length - 1];
        for (MemoryUnit currentUnit : MemoryUnit.values()) {
            if (currentUnit.getLimit().compareTo(this.byteSize) <= 0) continue;
            to = currentUnit;
            break;
        }
        return to;
    }

    public BigDecimal getBestValue() {
        MemoryUnit bestUnit = this.getBestUnit();
        return this.getRoundedSizeConverted(bestUnit);
    }

    private String getBestDisplayValue(boolean valueOnly) {
        return this.getFormattedValue(this.getBestUnit(), valueOnly);
    }

    public String getBestDisplayValueOnly() {
        return this.getBestDisplayValue(true);
    }

    public String getBestDisplayValue() {
        return this.getBestDisplayValue(false);
    }

    private String getFormattedValue(MemoryUnit to, boolean valueOnly) {
        BigDecimal bestDisplayValue = this.getRoundedSizeConverted(to);
        StringBuilder sb = new StringBuilder(128);
        sb.append(new DecimalFormat().format(bestDisplayValue));
        if (!valueOnly) {
            sb.append(" ");
            sb.append(to.getLabel());
        }
        return sb.toString();
    }

    public String getFormattedValueOnly(MemoryUnit to) {
        return this.getFormattedValue(to, true);
    }

    public String getFormattedValue(MemoryUnit to) {
        return this.getFormattedValue(to, false);
    }
}

