/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.thread.task;

import java.util.List;
import java.util.concurrent.Callable;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.thread.task.RequestTaskManager;
import org.silverpeas.kernel.SilverpeasException;
import org.silverpeas.kernel.logging.SilverLogger;

public abstract class AbstractRequestTask<C extends ProcessContext>
implements Callable<Void> {
    private static final int NO_REQUEST_QUEUE_LIMIT = 0;
    RequestTaskManager.RequestTaskMonitor<? extends AbstractRequestTask<?>, C> monitor = null;

    protected AbstractRequestTask() {
    }

    protected int getRequestQueueLimit() {
        return 0;
    }

    protected C getProcessContext() {
        return null;
    }

    @Override
    public final Void call() throws Exception {
        Request<C> currentRequest = this.nextRequest();
        while (currentRequest != null) {
            CacheAccessorProvider.getThreadCacheAccessor().getCache().clear();
            try {
                this.monitor.releaseAccess();
                this.processRequest(currentRequest);
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
            currentRequest = this.nextRequest();
            if (currentRequest == null) {
                this.debug("no more request to process, waiting 500ms about new requests", new Object[0]);
                Thread.sleep(500L);
                currentRequest = this.nextRequest();
            }
            if (currentRequest != null) continue;
            try {
                this.debug("no more request to process after waiting a while, invoking afterNoMoreRequest method", new Object[0]);
                this.afterNoMoreRequest();
            }
            catch (Exception e) {
                SilverLogger.getLogger((Object)this).error((Throwable)e);
            }
            finally {
                this.debug("requests could be pushed during afterNoMoreRequest method execution", new Object[0]);
                currentRequest = this.nextRequest();
            }
        }
        this.debug("no more request to perform, stopping a thread in charge of request processing", new Object[0]);
        return null;
    }

    protected void processRequest(Request<C> request) throws SilverpeasException {
        this.debug("processing a request: {0}", request.getClass().getSimpleName());
        try {
            request.process(this.getProcessContext());
        }
        catch (Exception e) {
            SilverLogger.getLogger((Object)this).silent((Throwable)e);
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw new SilverpeasException((Throwable)e);
        }
    }

    protected void afterNoMoreRequest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Request<C> nextRequest() {
        List list = this.monitor.requestList;
        synchronized (list) {
            this.debug("checking the next request to process", new Object[0]);
            Request nextRequest = !this.monitor.requestList.isEmpty() ? this.monitor.requestList.remove(0) : null;
            return nextRequest;
        }
    }

    private void debug(String message, Object ... parameters) {
        SilverLogger.getLogger((String)"silverpeas.core.thread").debug(this.getClass().getSimpleName() + " - consumer thread - " + message, parameters);
    }

    public static interface ProcessContext {
    }

    public static interface Request<C> {
        default public String getReplacementId() {
            return null;
        }

        public void process(C var1) throws InterruptedException;
    }
}

