/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.datasource.repository.jpa;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.silverpeas.core.persistence.datasource.repository.Parameters;
import org.silverpeas.core.persistence.datasource.repository.jpa.DateCollectionNamedParameter;
import org.silverpeas.core.persistence.datasource.repository.jpa.DateNamedParameter;
import org.silverpeas.core.persistence.datasource.repository.jpa.EnumCollectionNamedParameter;
import org.silverpeas.core.persistence.datasource.repository.jpa.EnumNamedParameter;
import org.silverpeas.core.persistence.datasource.repository.jpa.NamedParameter;
import org.silverpeas.core.persistence.datasource.repository.jpa.ObjectNamedParameter;
import org.silverpeas.core.util.CollectionUtil;

public class NamedParameters
implements Parameters {
    private String lastParameterName;
    final Map<String, NamedParameter<?>> parametersPerName = new LinkedHashMap();

    NamedParameters() {
    }

    public String getLastParameterName() {
        return this.lastParameterName;
    }

    public <T> NamedParameter<T> getParameter(String parameterName) {
        return this.parametersPerName.get(parameterName);
    }

    @Override
    public NamedParameters add(String name, Object value) {
        return this.add(name, value, null);
    }

    public NamedParameters add(String name, Object value, TemporalType temporalType) {
        if (value instanceof Object[] && ((Object[])value)[0] instanceof Date && temporalType != null) {
            this.parametersPerName.put(name, new DateCollectionNamedParameter(name, CollectionUtil.asSet((Date[])value), temporalType));
        } else if (value instanceof Collection && !((Collection)value).isEmpty() && ((Collection)value).iterator().next() instanceof Date && temporalType != null) {
            this.parametersPerName.put(name, new DateCollectionNamedParameter(name, (Set<Date>)new HashSet<Date>((Collection)value), temporalType));
        } else if (value instanceof Date && temporalType != null) {
            this.parametersPerName.put(name, new DateNamedParameter(name, (Date)value, temporalType));
        } else if (value instanceof Object[] && ((Object[])value).length > 0 && ((Object[])value)[0] instanceof Enum) {
            this.parametersPerName.put(name, new EnumCollectionNamedParameter(name, CollectionUtil.asSet((Enum[])value)));
        } else if (value instanceof Collection && !((Collection)value).isEmpty() && ((Collection)value).iterator().next() instanceof Enum) {
            this.parametersPerName.put(name, new EnumCollectionNamedParameter(name, new HashSet((Collection)value)));
        } else if (value instanceof Enum) {
            this.parametersPerName.put(name, new EnumNamedParameter(name, (Enum)value));
        } else {
            this.parametersPerName.put(name, new ObjectNamedParameter(name, value));
        }
        this.lastParameterName = name;
        return this;
    }

    public <E extends Query> E applyTo(E query) {
        for (NamedParameter<?> namedParameter : this.parametersPerName.values()) {
            if (namedParameter instanceof DateNamedParameter) {
                DateNamedParameter dateParameter = (DateNamedParameter)namedParameter;
                query.setParameter(dateParameter.getName(), (Date)dateParameter.getValue(), dateParameter.getTemporalType());
                continue;
            }
            query.setParameter(namedParameter.getName(), namedParameter.getValue());
        }
        return query;
    }
}

