/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence.datasource;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.cache.service.CacheAccessorProvider;
import org.silverpeas.core.persistence.datasource.PersistOperation;
import org.silverpeas.core.persistence.datasource.PersistenceOperation;
import org.silverpeas.core.persistence.datasource.UpdateOperation;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.cache.model.SimpleCache;

public class OperationContext {
    private static final String CACHE_KEY = OperationContext.class.getName();
    private final List<State> states = new ArrayList<State>();
    private boolean updatingInCaseOfCreation = false;
    private User user = null;
    private final List<PersistenceOperation> persistenceOperations = new ArrayList<PersistenceOperation>();

    private OperationContext() {
    }

    public static OperationContext fromUser(String userId) {
        return OperationContext.fromUser(User.getById(userId));
    }

    public static OperationContext fromUser(User user) {
        return OperationContext.getFromCache().withUser(user);
    }

    public static OperationContext fromCurrentRequester() {
        OperationContext context = OperationContext.getFromCache();
        return context.getUser() == null ? context.withUser(User.getCurrentRequester()) : context;
    }

    public static OperationContext getFromCache() {
        SimpleCache cache = CacheAccessorProvider.getThreadCacheAccessor().getCache();
        OperationContext context = (OperationContext)cache.get((Object)CACHE_KEY, OperationContext.class);
        if (context == null) {
            context = new OperationContext();
            cache.put((Object)CACHE_KEY, (Object)context);
        }
        return context;
    }

    public static boolean statesOf(State ... states) {
        OperationContext context = OperationContext.getFromCache();
        if (context.states.isEmpty()) {
            return false;
        }
        for (State state : states) {
            if (context.states.contains((Object)state)) continue;
            return false;
        }
        return true;
    }

    public static void addStates(State ... states) {
        OperationContext context = OperationContext.getFromCache();
        context.states.addAll(Arrays.asList(states));
    }

    public static void removeStates(State ... states) {
        OperationContext context = OperationContext.getFromCache();
        context.states.removeAll(Arrays.asList(states));
    }

    public OperationContext withUser(User user) {
        this.user = user;
        return this;
    }

    public OperationContext setUpdatingInCaseOfCreation() {
        return this.setUpdatingInCaseOfCreation(true);
    }

    public boolean isUpdatingInCaseOfCreation() {
        return this.updatingInCaseOfCreation;
    }

    public OperationContext setUpdatingInCaseOfCreation(boolean updatingInCaseOfCreation) {
        this.updatingInCaseOfCreation = updatingInCaseOfCreation;
        return this;
    }

    public User getUser() {
        return this.user;
    }

    public <T extends PersistenceOperation> T getPersistenceOperation(Class<T> operationType) {
        Annotation annotation = operationType.getAnnotation(UpdateOperation.class);
        if (annotation == null && (annotation = operationType.getAnnotation(PersistOperation.class)) == null) {
            return null;
        }
        UpdateOperation qualifier = annotation;
        return (T)this.persistenceOperations.stream().filter(c -> c.getClass().getAnnotation(qualifier.annotationType()) != null && c.getClass().equals(operationType)).findFirst().orElseGet(() -> {
            PersistenceOperation c = (PersistenceOperation)ServiceProvider.getService(operationType, qualifier);
            this.persistenceOperations.add(c);
            return c;
        });
    }

    public static enum State {
        EXPORT,
        IMPORT;

    }
}

