/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence;

import javax.annotation.Resource;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.Transactional;
import org.silverpeas.core.annotation.Bean;
import org.silverpeas.core.persistence.TransactionProvider;
import org.silverpeas.core.persistence.TransactionRuntimeException;
import org.silverpeas.core.util.Process;
import org.silverpeas.kernel.annotation.Technical;

@Technical
@Bean
public class Transaction {
    @Resource(mappedName="java:/TransactionManager")
    private TransactionManager transactionManager;

    public static Transaction getTransaction() {
        return TransactionProvider.getTransaction();
    }

    public static <V> V performInOne(Process<V> process) {
        return Transaction.getTransaction().perform(process);
    }

    public static <V> V performInNew(Process<V> process) {
        return Transaction.getTransaction().performNew(process);
    }

    public static boolean isTransactionActive() {
        return Transaction.getTransaction().isActive();
    }

    public static int getTransactionStatus() {
        return Transaction.getTransaction().getStatus();
    }

    @Transactional
    public <V> V perform(Process<V> process) {
        try {
            return process.execute();
        }
        catch (Exception e) {
            throw new TransactionRuntimeException(e);
        }
    }

    public int getStatus() {
        try {
            return this.transactionManager.getStatus();
        }
        catch (SystemException e) {
            throw new TransactionRuntimeException(e);
        }
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public <V> V performNew(Process<V> process) {
        try {
            return process.execute();
        }
        catch (Exception e) {
            throw new TransactionRuntimeException(e);
        }
    }

    @Transactional(value=Transactional.TxType.MANDATORY)
    protected boolean isActive() {
        return this.getStatus() == 0;
    }
}

