/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.persistence;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class EntityReference<T> {
    private static final String[] TechnicalTerms = new String[]{"Detail", "Full", "Complete", "Silver", "Content", "Silverpeas"};
    private final String id;
    public static final String UNKNOWN_TYPE = "UNKNOWN";

    public EntityReference(String id) {
        this.id = id;
    }

    public final String getId() {
        return this.id;
    }

    public final String getType() {
        String type = "";
        Type genericSuperclass = this.getClass().getGenericSuperclass();
        if (genericSuperclass instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericSuperclass;
            Type paramType = pt.getActualTypeArguments()[0];
            type = paramType.toString();
            type = type.substring(type.lastIndexOf(".") + 1);
        }
        return EntityReference.getType(type);
    }

    public static String getType(Class aClass) {
        return EntityReference.getType(aClass.getSimpleName());
    }

    public static String getType(String classSimpleName) {
        String type = classSimpleName;
        for (String term : TechnicalTerms) {
            if (!type.contains(term)) continue;
            type = type.replace(term, "");
        }
        if (type.isEmpty()) {
            type = UNKNOWN_TYPE;
        }
        return type.toUpperCase();
    }

    public abstract T getEntity();

    public int hashCode() {
        int hash = 5;
        hash = 67 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 67 * hash + (this.getType() != null ? this.getType().hashCode() : 0);
        return hash;
    }

    public boolean equals(Object anotherReference) {
        if (anotherReference == null) {
            return false;
        }
        if (this.getClass() != anotherReference.getClass()) {
            return false;
        }
        return this.hashCode() == anotherReference.hashCode();
    }
}

