/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.notification.user.delayed.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang3.StringUtils;
import org.silverpeas.core.i18n.I18n;
import org.silverpeas.core.notification.user.client.NotificationParameters;
import org.silverpeas.core.notification.user.client.constant.NotifAction;
import org.silverpeas.core.notification.user.client.constant.NotifChannel;
import org.silverpeas.core.notification.user.model.NotificationResourceData;
import org.silverpeas.core.notification.user.server.NotificationData;
import org.silverpeas.core.persistence.datasource.model.identifier.UniqueLongIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;

@Entity
@Table(name="st_delayednotification")
@NamedQueries(value={@NamedQuery(name="DelayedNotificationData.findDistinctUserByChannel", query="select distinct userId from DelayedNotificationData where channel in (:channels)"), @NamedQuery(name="DelayedNotificationData.findByUserId", query="select d from DelayedNotificationData d where d.userId = :userId and d.channel in (:channels) order by d.channel"), @NamedQuery(name="DelayedNotificationData.deleteByIds", query="delete from DelayedNotificationData d where d.id in (:ids)")})
public class DelayedNotificationData
extends BasicJpaEntity<DelayedNotificationData, UniqueLongIdentifier>
implements Serializable {
    private static final long serialVersionUID = 3477090528448919931L;
    @Column(name="userId", nullable=false)
    private Integer userId;
    @Column(name="fromUserId", nullable=false)
    private Integer fromUserId;
    @Column(name="channel", nullable=false)
    private Integer channel;
    @Column(name="action", nullable=false)
    private Integer action;
    @Column(name="language", nullable=false)
    private String language;
    @Column(name="creationDate", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date creationDate;
    @Column(name="message")
    private String message;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="notificationResourceId", referencedColumnName="id", nullable=false)
    private NotificationResourceData resource;
    @Transient
    private boolean sendImmediately = false;
    @Transient
    private transient NotificationData notificationData;
    @Transient
    private transient NotificationParameters notificationParameters;

    public boolean isValid() {
        return this.getUserId() != null && this.getFromUserId() != null && this.getChannel() != null && this.getAction() != null && StringUtils.isNotBlank((CharSequence)this.getLanguage()) && this.getResource() != null && this.getResource().isValid();
    }

    @Override
    protected void performBeforePersist() {
        super.performBeforePersist();
        this.creationDate = new Date();
        if (!StringUtils.isNotBlank((CharSequence)this.language)) {
            this.language = I18n.get().getDefaultLanguage();
        }
    }

    public void setId(Long id) {
        this.setId(id != null ? String.valueOf(id) : null);
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public void setUserId(String userId) {
        this.userId = Integer.valueOf(userId);
    }

    public Integer getFromUserId() {
        return this.fromUserId;
    }

    public void setFromUserId(Integer fromUserId) {
        this.fromUserId = fromUserId;
    }

    public NotifChannel getChannel() {
        return NotifChannel.decode(this.channel).orElse(null);
    }

    public void setChannel(NotifChannel channel) {
        this.channel = channel != null ? Integer.valueOf(channel.getId()) : null;
    }

    public NotifAction getAction() {
        return NotifAction.decode(this.action);
    }

    public void setAction(NotifAction action) {
        this.action = action != null ? Integer.valueOf(action.getId()) : null;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public NotificationResourceData getResource() {
        return this.resource;
    }

    public void setResource(NotificationResourceData resource) {
        this.resource = resource;
    }

    public boolean isSendImmediately() {
        return this.sendImmediately;
    }

    public void setSendImmediately(boolean sendImmediately) {
        this.sendImmediately = sendImmediately;
    }

    public NotificationData getNotificationData() {
        return this.notificationData;
    }

    public void setNotificationData(NotificationData notificationData) {
        this.notificationData = notificationData;
    }

    public NotificationParameters getNotificationParameters() {
        return this.notificationParameters;
    }

    public void setNotificationParameters(NotificationParameters notificationParameters) {
        this.notificationParameters = notificationParameters;
    }

    @Override
    public boolean equals(Object notificationData) {
        return super.equals(notificationData);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

