/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.initialization;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.enterprise.inject.Any;
import org.silverpeas.core.initialization.Initialization;
import org.silverpeas.core.util.ServiceProvider;
import org.silverpeas.kernel.logging.SilverLogger;

public class SilverpeasServiceInitialization {
    private SilverpeasServiceInitialization() {
    }

    @SafeVarargs
    public static void start(Predicate<Initialization> ... filters) {
        SilverLogger logger = SilverLogger.getLogger((String)"silverpeas");
        logger.info("Silverpeas Services Initialization...", new Object[0]);
        SilverpeasServiceInitialization.getAllInitializations(filters).forEach(i -> {
            String name = SilverpeasServiceInitialization.getName(i);
            try {
                logger.info(" -> {0} initialization...", new Object[]{name});
                i.init();
                logger.info("    {0} initialization done.", new Object[]{name});
            }
            catch (Exception e) {
                logger.error("    {0} initialization failure!", new Object[]{name});
                logger.error(e.getMessage(), new Object[0]);
            }
        });
    }

    @SafeVarargs
    public static void stop(Predicate<Initialization> ... filters) {
        SilverLogger logger = SilverLogger.getLogger((String)"silverpeas");
        logger.info("Silverpeas Services Release...", new Object[0]);
        SilverpeasServiceInitialization.getAllInitializations(filters).forEach(i -> {
            String name = SilverpeasServiceInitialization.getName(i);
            try {
                logger.info(" -> {0} release...", new Object[]{name});
                i.release();
                logger.info("    {0} release done.", new Object[]{name});
            }
            catch (Exception ex) {
                logger.error("    {0} release failure!", new Object[]{name});
                logger.error(ex.getMessage(), new Object[0]);
            }
        });
    }

    @SafeVarargs
    private static Stream<Initialization> getAllInitializations(Predicate<Initialization> ... filters) {
        return ServiceProvider.getAllServices(Initialization.class, new Annotation[]{Any.Literal.INSTANCE}).stream().filter(Stream.of(filters).reduce(Predicate::and).orElse(x -> true)).sorted(Comparator.comparing(Initialization::getPriority));
    }

    private static String getName(Initialization init) {
        return init.getClass().getSimpleName().replaceAll("\\$.+", "");
    }
}

