/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang3.tuple.Pair;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.calendar.AttendeeSet;
import org.silverpeas.core.calendar.AttributeSet;
import org.silverpeas.core.calendar.Calendar;
import org.silverpeas.core.calendar.CalendarComponent;
import org.silverpeas.core.calendar.CalendarEvent;
import org.silverpeas.core.calendar.CalendarEventOccurrenceGenerator;
import org.silverpeas.core.calendar.CalendarResourcePathProvider;
import org.silverpeas.core.calendar.CalendarTimeWindow;
import org.silverpeas.core.calendar.CategorySet;
import org.silverpeas.core.calendar.EventOperationResult;
import org.silverpeas.core.calendar.Occurrence;
import org.silverpeas.core.calendar.Priority;
import org.silverpeas.core.calendar.Recurrence;
import org.silverpeas.core.calendar.VisibilityLevel;
import org.silverpeas.core.calendar.repository.CalendarEventOccurrenceRepository;
import org.silverpeas.core.contribution.model.Contribution;
import org.silverpeas.core.contribution.model.ContributionIdentifier;
import org.silverpeas.core.contribution.model.WithPermanentLink;
import org.silverpeas.core.contribution.model.WysiwygContent;
import org.silverpeas.core.date.Period;
import org.silverpeas.core.persistence.Transaction;
import org.silverpeas.core.persistence.datasource.model.IdentifiableEntity;
import org.silverpeas.core.persistence.datasource.model.identifier.ExternalStringIdentifier;
import org.silverpeas.core.persistence.datasource.model.jpa.BasicJpaEntity;
import org.silverpeas.core.persistence.datasource.model.jpa.JpaEntityReflection;
import org.silverpeas.core.reminder.WithReminder;
import org.silverpeas.core.util.ResourcePath;
import org.silverpeas.core.web.mvc.route.ComponentInstanceRoutingMapProviderByInstance;
import org.silverpeas.kernel.util.Mutable;

@Entity
@Table(name="sb_cal_occurrences")
@NamedQueries(value={@NamedQuery(name="occurrenceByEventsAndByPeriod", query="SELECT o FROM CalendarEventOccurrence o WHERE o.event in :events AND ((o.component.period.startDateTime <= :startDateTime AND   o.component.period.endDateTime > :startDateTime) OR (o.component.period.startDateTime >= :startDateTime AND   o.component.period.startDateTime < :endDateTime))"), @NamedQuery(name="occurrenceByEventSince", query="SELECT o FROM CalendarEventOccurrence o WHERE o.event = :event AND o.component.period.startDateTime >= :date"), @NamedQuery(name="occurrenceByEvent", query="SELECT o FROM CalendarEventOccurrence o WHERE o.event = :event")})
public class CalendarEventOccurrence
extends BasicJpaEntity<CalendarEventOccurrence, ExternalStringIdentifier>
implements IdentifiableEntity,
Occurrence,
WithReminder,
WithPermanentLink {
    public static final String TYPE = "CalendarEventOccurrence";
    public static final Comparator<CalendarEventOccurrence> COMPARATOR_BY_ORIGINAL_DATE_ASC = Comparator.comparing(o -> o.getOriginalStartDate().toString());
    public static final Comparator<CalendarEventOccurrence> COMPARATOR_BY_DATE_ASC = Comparator.comparing(o -> o.getStartDate().toString());
    public static final Comparator<CalendarEventOccurrence> COMPARATOR_BY_DATE_DESC = (o1, o2) -> o2.getStartDate().toString().compareTo(o1.getStartDate().toString());
    @ManyToOne(optional=false, fetch=FetchType.EAGER)
    @JoinColumn(name="eventId", referencedColumnName="id")
    private CalendarEvent event;
    @OneToOne(optional=false, fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="componentId", referencedColumnName="id", unique=true)
    private CalendarComponent component;
    @Transient
    private CalendarEventOccurrence previousState;

    protected CalendarEventOccurrence() {
    }

    CalendarEventOccurrence(CalendarEvent event, Temporal startDate, Temporal endDate) {
        this.setId(CalendarEventOccurrence.generateId(event, startDate));
        this.event = event;
        this.component = event.asCalendarComponent().copy();
        JpaEntityReflection.setCreationData(this.component, event.getCreator(), event.getCreationDate());
        JpaEntityReflection.setUpdateData(this.component, event.getLastUpdater(), event.getLastUpdateDate());
        this.component.setPeriod(Period.between(startDate, endDate));
    }

    public static Optional<CalendarEventOccurrence> getBy(CalendarEvent event, Temporal occurrenceStartDate) {
        Temporal startDate = occurrenceStartDate;
        if (startDate instanceof OffsetDateTime) {
            startDate = ((OffsetDateTime)occurrenceStartDate).atZoneSameInstant(ZoneOffset.UTC).toOffsetDateTime();
        }
        return CalendarEventOccurrence.getById(CalendarEventOccurrence.generateId(event, startDate));
    }

    public static Optional<CalendarEventOccurrence> getById(String id) {
        CalendarEventOccurrenceRepository repository = CalendarEventOccurrenceRepository.get();
        Mutable occurrence = Mutable.ofNullable((Object)((CalendarEventOccurrence)repository.getById(id)));
        if (!occurrence.isPresent()) {
            Pair<String, Temporal> explodedId = CalendarEventOccurrence.explodeId(id);
            String eventId = (String)explodedId.getLeft();
            Temporal startDate = (Temporal)explodedId.getRight();
            Optional<CalendarEvent> event = Optional.ofNullable(CalendarEvent.getById(eventId));
            event.ifPresent(e -> {
                if (e.isRecurrent()) {
                    LocalDate occEndDate;
                    LocalDate occStartDate;
                    if (startDate instanceof LocalDate) {
                        LocalDate date = (LocalDate)startDate;
                        occStartDate = date.minusDays(1L);
                        occEndDate = date.plusDays(1L);
                    } else {
                        OffsetDateTime dateTime = (OffsetDateTime)startDate;
                        occStartDate = dateTime.minusDays(1L).toLocalDate();
                        occEndDate = dateTime.plusDays(1L).toLocalDate();
                    }
                    List<CalendarEventOccurrence> occurrences = e.getCalendar().between(occStartDate, occEndDate).getEventOccurrences();
                    occurrences.removeIf(o -> !o.getCalendarEvent().getId().equals(eventId) || !o.getStartDate().equals(startDate));
                    if (occurrences.size() == 1) {
                        occurrence.set((Object)occurrences.get(0));
                    }
                } else {
                    occurrence.set((Object)new CalendarEventOccurrence((CalendarEvent)e, e.getStartDate(), e.getEndDate()));
                }
            });
        }
        return Optional.ofNullable((CalendarEventOccurrence)occurrence.orElse(null));
    }

    private static CalendarEventOccurrenceGenerator generator() {
        return CalendarEventOccurrenceGenerator.get();
    }

    static List<CalendarEventOccurrence> getOccurrencesIn(CalendarTimeWindow timeWindow) {
        List<CalendarEventOccurrence> occurrences = CalendarEventOccurrence.generator().generateOccurrencesIn(timeWindow);
        List<CalendarEventOccurrence> modified = CalendarEventOccurrenceRepository.get().getAll(timeWindow.getEvents(), timeWindow.getPeriod());
        modified.forEach(o -> {
            int idx = occurrences.indexOf(o);
            if (idx < 0) {
                occurrences.add((CalendarEventOccurrence)o);
            } else {
                occurrences.set(idx, (CalendarEventOccurrence)o);
            }
        });
        return occurrences;
    }

    static Optional<CalendarEventOccurrence> getNextOccurrence(CalendarEvent event, ZonedDateTime dateTime) {
        CalendarEventOccurrence occurrence = CalendarEventOccurrence.generator().generateNextOccurrenceOf(event, dateTime);
        if (occurrence != null) {
            CalendarEventOccurrence modifiedOccurrence = (CalendarEventOccurrence)CalendarEventOccurrenceRepository.get().getById(occurrence.getId());
            return Optional.of(modifiedOccurrence == null ? occurrence : modifiedOccurrence);
        }
        return Optional.empty();
    }

    @Override
    public Optional<CalendarEvent> getParent() {
        return Optional.ofNullable(this.getCalendarEvent());
    }

    @Override
    public ContributionIdentifier getIdentifier() {
        return ContributionIdentifier.from(this.getCalendarEvent().getCalendar().getComponentInstanceId(), this.getId(), this.getContributionType());
    }

    @Override
    public User getCreator() {
        return this.component.getCreator();
    }

    @Override
    public Date getCreationDate() {
        return this.component.getCreationDate();
    }

    @Override
    public User getLastUpdater() {
        return this.component.getLastUpdater();
    }

    @Override
    public boolean canBeAccessedBy(User user) {
        return this.getCalendarEvent().canBeAccessedBy(user);
    }

    @Override
    public String getContributionType() {
        return TYPE;
    }

    public CalendarEvent getCalendarEvent() {
        return this.event;
    }

    @Override
    public Calendar getCalendar() {
        return this.getCalendarEvent().getCalendar();
    }

    @Override
    public Temporal getStartDate() {
        return this.component.getPeriod().getStartDate();
    }

    @Override
    public Temporal getEndDate() {
        return this.component.getPeriod().getEndDate();
    }

    @Override
    public <T extends Contribution> Optional<ResourcePath<T>> getResourcePath() {
        return CalendarResourcePathProvider.get().getResourcePathOf(this);
    }

    public Temporal getOriginalStartDate() {
        return (Temporal)CalendarEventOccurrence.explodeId(this.getId()).getRight();
    }

    @Override
    public void setPeriod(Period newPeriod) {
        this.component.setPeriod(newPeriod);
    }

    @Override
    public Period getPeriod() {
        return this.component.getPeriod();
    }

    public void setDay(LocalDate newDay) {
        Period newPeriod = Period.between(newDay, newDay);
        this.setPeriod(newPeriod);
    }

    @Override
    public String getTitle() {
        return this.component.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.component.setTitle(title);
    }

    public AttendeeSet getAttendees() {
        return this.component.getAttendees();
    }

    @Override
    public String getDescription() {
        return this.component.getDescription();
    }

    public void setDescription(String description) {
        this.component.setDescription(description);
    }

    public String getLocation() {
        return this.component.getLocation();
    }

    public void setLocation(String location) {
        this.component.setLocation(location);
    }

    public AttributeSet getAttributes() {
        return this.component.getAttributes();
    }

    public Priority getPriority() {
        return this.component.getPriority();
    }

    public void setPriority(Priority priority) {
        this.component.setPriority(priority);
    }

    public CategorySet getCategories() {
        return this.event.getCategories();
    }

    public VisibilityLevel getVisibilityLevel() {
        return this.event.getVisibilityLevel();
    }

    @Override
    public boolean isOnAllDay() {
        return this.getPeriod().isInDays();
    }

    public long getSequence() {
        return this.component.isPersisted() ? this.component.getSequence() : this.event.getSequence();
    }

    @Override
    public Date getLastUpdateDate() {
        return this.component.getLastUpdateDate();
    }

    public Optional<WysiwygContent> getContent() {
        return this.getCalendarEvent().getContent();
    }

    @Override
    public String getPermalink() {
        return ComponentInstanceRoutingMapProviderByInstance.get().getByInstanceId(this.getCalendarEvent().getCalendar().getComponentInstanceId()).absolute().getPermalink(this.getIdentifier()).toString();
    }

    public boolean isBefore(CalendarEventOccurrence occurrence) {
        return this.getStartDate().toString().compareTo(occurrence.getStartDate().toString()) < 0;
    }

    @Override
    public CalendarComponent asCalendarComponent() {
        return this.component;
    }

    public EventOperationResult updateSinceMe() {
        return this.getCalendarEvent().updateSince(this);
    }

    public EventOperationResult update() {
        return this.getCalendarEvent().updateOnly(this);
    }

    public EventOperationResult updateFrom(CalendarEventOccurrence occurrence) {
        occurrence.asCalendarComponent().copyTo(this.component);
        return this.update();
    }

    public EventOperationResult deleteSinceMe() {
        return this.getCalendarEvent().deleteSince(this);
    }

    public EventOperationResult delete() {
        return this.getCalendarEvent().deleteOnly(this);
    }

    CalendarEventOccurrence copyWithEvent(CalendarEvent event) {
        CalendarEventOccurrence newOccurrence = new CalendarEventOccurrence();
        newOccurrence.setId(CalendarEventOccurrence.generateId(event, this.getOriginalStartDate()));
        newOccurrence.event = event;
        newOccurrence.component = this.component.copy();
        newOccurrence.component.setCalendar(event.getCalendar());
        return newOccurrence;
    }

    public boolean isModifiedSince(CalendarEventOccurrence previous) {
        if (!this.getId().equals(previous.getId())) {
            throw new IllegalArgumentException("The event occurrence of id " + previous.getId() + " isn't the expected one " + this.getId());
        }
        if (this.getVisibilityLevel() != previous.getVisibilityLevel() || !this.getCategories().equals(previous.getCategories())) {
            return true;
        }
        return this.asCalendarComponent().isModifiedSince(previous.asCalendarComponent());
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    CalendarEvent toCalendarEvent() {
        return CalendarEvent.from(this);
    }

    CalendarEvent toRecurrentCalendarEvent() {
        CalendarEvent newEvent = this.toCalendarEvent();
        if (this.getCalendarEvent().isRecurrent()) {
            Recurrence recurrence = this.getCalendarEvent().getRecurrence().copy();
            recurrence.clearsAllExceptionDates();
            if (!this.getCalendarEvent().getRecurrence().isEndless()) {
                recurrence.until(this.getCalendarEvent().getRecurrence().getEndDate().orElseThrow(IllegalArgumentException::new));
            }
            newEvent.recur(recurrence);
        }
        return newEvent;
    }

    final void setCalendarEvent(CalendarEvent event) {
        this.setId(CalendarEventOccurrence.generateId(event, this.getOriginalStartDate()));
        this.event = event;
        this.component.setCalendar(event.getCalendar());
    }

    void saveIntoPersistence() {
        Transaction.performInOne(() -> {
            boolean modifiedSince;
            CalendarComponent pcc;
            CalendarEventOccurrence previous;
            CalendarEventOccurrenceRepository repository = CalendarEventOccurrenceRepository.get();
            CalendarEventOccurrence calendarEventOccurrence = previous = this.getCalendarEvent().hasDeletedAllOccurrencesBecauseOfDateOrRecurrenceChange() ? null : this.getPreviousState();
            if (previous != null) {
                pcc = previous.asCalendarComponent();
                modifiedSince = this.isModifiedSince(previous);
            } else {
                pcc = this.event.asCalendarComponent();
                CalendarComponent pccClone = pcc.copy();
                pccClone.setPeriod(this.component.getPeriod());
                boolean bl = modifiedSince = this.component.isModifiedSince(pccClone) || !this.getOriginalStartDate().toString().equals(this.getStartDate().toString());
            }
            if (!modifiedSince && this.getAttendees().onlyAttendeePropertyChange(pcc.getAttendees())) {
                ((CalendarComponent)this.component.createdBy(pcc.getCreator(), pcc.getCreationDate())).updatedBy(pcc.getLastUpdater(), pcc.getLastUpdateDate());
            } else {
                this.component.incrementSequence();
            }
            return repository.save(this);
        });
    }

    void deleteFromPersistence() {
        Transaction.performInOne(() -> {
            CalendarEventOccurrenceRepository repository = CalendarEventOccurrenceRepository.get();
            repository.delete(new CalendarEventOccurrence[]{this});
            return null;
        });
    }

    void deleteAllSinceMeFromThePersistence() {
        Transaction.performInOne(() -> {
            CalendarEventOccurrenceRepository repository = CalendarEventOccurrenceRepository.get();
            List<CalendarEventOccurrence> occurrences = repository.getAllSince(this);
            repository.delete(occurrences);
            return occurrences.size();
        });
    }

    boolean isDateChanged() {
        CalendarEventOccurrence previous = this.getPreviousState();
        return previous != null && !previous.getPeriod().equals(this.getPeriod()) || previous == null && !this.getOriginalStartDate().equals(this.getStartDate());
    }

    private CalendarEventOccurrence getPreviousState() {
        if (this.previousState == null && this.getId() != null) {
            this.previousState = Transaction.performInNew(() -> {
                CalendarEventOccurrenceRepository repository = CalendarEventOccurrenceRepository.get();
                return (CalendarEventOccurrence)repository.getById(this.getId());
            });
        }
        return this.previousState;
    }

    private static String generateId(CalendarEvent event, Temporal occurrenceStartDate) {
        return event.getId() + "@" + String.valueOf(occurrenceStartDate);
    }

    private static Pair<String, Temporal> explodeId(String id) {
        String[] explodedId = id.split("@");
        return Pair.of((Object)explodedId[0], (Object)CalendarEventOccurrence.getDate(explodedId[1]));
    }

    private static Temporal getDate(String temporal) {
        if (temporal.contains("T")) {
            return OffsetDateTime.parse(temporal);
        }
        return LocalDate.parse(temporal);
    }
}

