/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.calendar.Calendar;

public class CalendarEventFilter {
    private final List<Calendar> calendars = new ArrayList<Calendar>();
    private final List<User> participants = new ArrayList<User>();
    private Instant synchronizationDateLimit = null;

    CalendarEventFilter() {
    }

    public CalendarEventFilter onCalendar(Calendar ... calendars) {
        return this.onCalendar(Arrays.asList(calendars));
    }

    public CalendarEventFilter onCalendar(List<Calendar> calendars) {
        this.calendars.addAll(calendars);
        return this;
    }

    public CalendarEventFilter onParticipants(User ... users) {
        return this.onParticipants(Arrays.asList(users));
    }

    public CalendarEventFilter onParticipants(Collection<User> users) {
        this.participants.addAll(users);
        return this;
    }

    public CalendarEventFilter onSynchronizationDateLimit(Instant dateTime) {
        this.synchronizationDateLimit = dateTime;
        return this;
    }

    public List<Calendar> getCalendars() {
        return this.calendars;
    }

    public List<User> getParticipants() {
        return this.participants;
    }

    public Optional<Instant> getSynchronizationDateLimit() {
        return Optional.ofNullable(this.synchronizationDateLimit);
    }
}

