/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.calendar;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.persistence.CascadeType;
import javax.persistence.Embeddable;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.silverpeas.core.admin.user.model.User;
import org.silverpeas.core.calendar.Attendee;
import org.silverpeas.core.calendar.AttendeeSuppliers;
import org.silverpeas.core.calendar.CalendarComponent;
import org.silverpeas.core.util.CollectionUtil;
import org.silverpeas.kernel.annotation.NonNull;

@Embeddable
public class AttendeeSet
implements Iterable<Attendee>,
Serializable {
    @Transient
    private CalendarComponent component;
    @OneToMany(mappedBy="component", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    private Set<Attendee> attendees = new HashSet<Attendee>();

    AttendeeSet(CalendarComponent component) {
        this.component = component;
    }

    protected AttendeeSet() {
    }

    @Override
    @NonNull
    public Iterator<Attendee> iterator() {
        return this.attendees.iterator();
    }

    @Override
    public void forEach(Consumer<? super Attendee> action) {
        this.attendees.forEach(action);
    }

    @Override
    public Spliterator<Attendee> spliterator() {
        return this.attendees.spliterator();
    }

    public Stream<Attendee> stream() {
        return this.attendees.stream();
    }

    public Optional<Attendee> get(String id) {
        return this.attendees.stream().filter(a -> a.getId().equals(id)).findFirst();
    }

    public Attendee add(String email) {
        Attendee attendee = AttendeeSuppliers.fromEmail(email).to(this.component);
        this.attendees.add(attendee);
        return attendee;
    }

    public Attendee add(User user) {
        Attendee attendee = AttendeeSuppliers.fromUser(user).to(this.component);
        this.attendees.add(attendee);
        return attendee;
    }

    void remove(Attendee attendee) {
        this.attendees.remove(attendee);
    }

    public AttendeeSet removeIf(Predicate<Attendee> filter) {
        this.attendees.removeIf(filter);
        return this;
    }

    public AttendeeSet clear() {
        this.attendees.clear();
        return this;
    }

    public boolean isEmpty() {
        return this.attendees.isEmpty();
    }

    public boolean contains(Attendee attendee) {
        return this.attendees.contains(attendee);
    }

    public int size() {
        return this.attendees.size();
    }

    public int hashCode() {
        return this.attendees.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof AttendeeSet && this.attendees.equals(((AttendeeSet)obj).attendees);
    }

    public boolean isSameAs(AttendeeSet attendees) {
        if (!this.equals(attendees)) {
            return false;
        }
        for (Attendee attendee : this.attendees) {
            Optional<Attendee> other = attendees.get(attendee.getId());
            if (other.isEmpty()) {
                return false;
            }
            Attendee otherAttendee = other.get();
            if (attendee.getParticipationStatus() != otherAttendee.getParticipationStatus() || attendee.getPresenceStatus() != otherAttendee.getPresenceStatus()) {
                return false;
            }
            if (attendee.getFullName().equals(otherAttendee.getFullName()) && attendee.getDelegate().equals(otherAttendee.getDelegate()) && attendee.getCalendarComponent().equals(otherAttendee.getCalendarComponent())) continue;
            return false;
        }
        return true;
    }

    public boolean isNotSameAs(AttendeeSet attendees) {
        return !this.isSameAs(attendees);
    }

    boolean onlyAttendeePropertyChange(AttendeeSet attendees) {
        long nbParticipationAnswersOrPresenceStatusChanges = this.stream().filter(Attendee::propertyChange).count();
        if (nbParticipationAnswersOrPresenceStatusChanges > 0L && this.size() == attendees.size()) {
            Collection<Attendee> sameAttendeesBetweenInternalAndGiven = CollectionUtil.intersection(this.attendees, attendees.attendees);
            return this.size() == sameAttendeesBetweenInternalAndGiven.size();
        }
        return false;
    }

    void copyTo(AttendeeSet otherAttendees) {
        this.attendees.stream().map(Attendee::copy).forEach(otherAttendees::add);
    }

    void add(Attendee attendee) {
        attendee.setCalendarComponent(this.component);
        this.attendees.add(attendee);
    }

    AttendeeSet withCalendarComponent(CalendarComponent component) {
        this.component = component;
        return this;
    }
}

