/*
 * Decompiled with CFR 0.152.
 */
package org.silverpeas.core.questioncontainer.container.service;

import java.sql.Connection;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngine;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagementEngineProvider;
import org.silverpeas.core.contribution.contentcontainer.content.ContentManagerException;
import org.silverpeas.core.contribution.contentcontainer.content.SilverContentVisibility;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerHeader;
import org.silverpeas.core.questioncontainer.container.model.QuestionContainerPK;
import org.silverpeas.kernel.util.StringUtil;

public class QuestionContainerContentManager {
    private static final String nullBeginDate = "0000/00/00";
    private static final String nullEndDate = "9999/99/99";

    public static int getSilverObjectId(String id, String peasId) throws ContentManagerException {
        return QuestionContainerContentManager.getContentManager().getSilverContentId(id, peasId);
    }

    public static int createSilverContent(Connection con, QuestionContainerHeader qC, String userId, boolean isVisible) throws ContentManagerException {
        SilverContentVisibility scv = new SilverContentVisibility(isVisible);
        QuestionContainerContentManager.setDateAttributes(scv, qC.getBeginDate(), qC.getEndDate());
        return QuestionContainerContentManager.getContentManager().addSilverContent(con, qC.getPK().getId(), qC.getPK().getComponentName(), userId, scv);
    }

    public static void updateSilverContentVisibility(QuestionContainerHeader qC, boolean isVisible) throws ContentManagerException {
        int silverContentId = QuestionContainerContentManager.getContentManager().getSilverContentId(qC.getPK().getId(), qC.getPK().getComponentName());
        if (silverContentId != -1) {
            SilverContentVisibility scv = new SilverContentVisibility(isVisible);
            QuestionContainerContentManager.setDateAttributes(scv, qC.getBeginDate(), qC.getEndDate());
            QuestionContainerContentManager.getContentManager().updateSilverContentVisibilityAttributes(scv, silverContentId);
        } else {
            QuestionContainerContentManager.createSilverContent(null, qC, qC.getCreatorId(), isVisible);
        }
    }

    private static void setDateAttributes(SilverContentVisibility visibility, String startDate, String endDate) {
        String updatableStart = StringUtil.isDefined((String)startDate) ? startDate : nullBeginDate;
        String updatableEnd = StringUtil.isDefined((String)endDate) ? endDate : nullEndDate;
        visibility.setVisibilityAttributes(updatableStart, updatableEnd);
    }

    public static void deleteSilverContent(Connection con, QuestionContainerPK pk) throws ContentManagerException {
        int contentId = QuestionContainerContentManager.getContentManager().getSilverContentId(pk.getId(), pk.getComponentName());
        QuestionContainerContentManager.getContentManager().removeSilverContent(con, contentId);
    }

    private static ContentManagementEngine getContentManager() {
        return ContentManagementEngineProvider.getContentManagementEngine();
    }
}

