/*
 * Decompiled with CFR 0.152.
 */
package edu.psu.swe.scim.spec.protocol.data;

import edu.psu.swe.scim.server.filter.FilterLexer;
import edu.psu.swe.scim.server.filter.FilterParser;
import edu.psu.swe.scim.spec.protocol.data.PatchPathListener;
import edu.psu.swe.scim.spec.protocol.filter.FilterParseException;
import edu.psu.swe.scim.spec.protocol.filter.ValuePathExpression;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchOperationPath {
    private static final Logger log = LoggerFactory.getLogger(PatchOperationPath.class);
    private ValuePathExpression valuePathExpression;

    public PatchOperationPath() {
    }

    public PatchOperationPath(String patchPath) throws FilterParseException {
        this.parsePatchPath(patchPath);
    }

    protected void parsePatchPath(String patchPath) throws FilterParseException {
        FilterLexer l = new FilterLexer((CharStream)new ANTLRInputStream(patchPath));
        FilterParser p = new FilterParser((TokenStream)new CommonTokenStream((TokenSource)l));
        p.setBuildParseTree(true);
        p.addErrorListener((ANTLRErrorListener)new BaseErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                throw new IllegalStateException("failed to parse at line " + line + " due to " + msg, (Throwable)e);
            }
        });
        try {
            FilterParser.PatchPathContext tree = p.patchPath();
            PatchPathListener patchPathListener = new PatchPathListener();
            ParseTreeWalker.DEFAULT.walk((ParseTreeListener)patchPathListener, (ParseTree)tree);
            this.valuePathExpression = patchPathListener.getValuePathExpression();
        }
        catch (IllegalStateException e) {
            throw new FilterParseException(e);
        }
    }

    public String toString() {
        return this.valuePathExpression.toFilter();
    }

    public ValuePathExpression getValuePathExpression() {
        return this.valuePathExpression;
    }

    public void setValuePathExpression(ValuePathExpression valuePathExpression) {
        this.valuePathExpression = valuePathExpression;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PatchOperationPath)) {
            return false;
        }
        PatchOperationPath other = (PatchOperationPath)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ValuePathExpression this$valuePathExpression = this.getValuePathExpression();
        ValuePathExpression other$valuePathExpression = other.getValuePathExpression();
        return !(this$valuePathExpression == null ? other$valuePathExpression != null : !((Object)this$valuePathExpression).equals(other$valuePathExpression));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PatchOperationPath;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ValuePathExpression $valuePathExpression = this.getValuePathExpression();
        result = result * 59 + ($valuePathExpression == null ? 43 : ((Object)$valuePathExpression).hashCode());
        return result;
    }
}

