/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.standby.codec;

final class Messages {
    static final byte HEADER_RECORD = 0;
    static final byte HEADER_SEGMENT = 1;
    static final byte HEADER_BLOB = 2;
    static final byte HEADER_REFERENCES = 3;
    static final String GET_HEAD = "h";
    static final String GET_SEGMENT = "s.";
    static final String GET_BLOB = "b.";
    static final String GET_REFERENCES = "r.";
    private static final String MAGIC = "Standby-CMD@";
    private static final String SEPARATOR = ":";

    private Messages() {
    }

    private static String newRequest(String clientId, String body, boolean delimited) {
        StringBuilder builder = new StringBuilder(MAGIC);
        if (clientId != null) {
            builder.append(clientId.replace(SEPARATOR, "#"));
        }
        builder.append(SEPARATOR);
        builder.append(body);
        if (delimited) {
            builder.append("\r\n");
        }
        return builder.toString();
    }

    static String newGetHeadRequest(String clientId, boolean delimited) {
        return Messages.newRequest(clientId, GET_HEAD, delimited);
    }

    static String newGetHeadRequest(String clientId) {
        return Messages.newGetHeadRequest(clientId, true);
    }

    static String newGetSegmentRequest(String clientId, String segmentId, boolean delimited) {
        return Messages.newRequest(clientId, GET_SEGMENT + segmentId, delimited);
    }

    static String newGetSegmentRequest(String clientId, String segmentId) {
        return Messages.newGetSegmentRequest(clientId, segmentId, true);
    }

    static String newGetReferencesRequest(String clientId, String segmentId, boolean delimited) {
        return Messages.newRequest(clientId, GET_REFERENCES + segmentId, delimited);
    }

    static String newGetReferencesRequest(String clientId, String segmentId) {
        return Messages.newGetReferencesRequest(clientId, segmentId, true);
    }

    static String newGetBlobRequest(String clientId, String blobId, boolean delimited) {
        return Messages.newRequest(clientId, GET_BLOB + blobId, delimited);
    }

    static String newGetBlobRequest(String clientId, String blobId) {
        return Messages.newGetBlobRequest(clientId, blobId, true);
    }

    static String extractMessageFrom(String payload) {
        if (payload.startsWith(MAGIC) && payload.length() > MAGIC.length()) {
            int i = payload.indexOf(SEPARATOR);
            return payload.substring(i + 1);
        }
        return null;
    }

    static String extractClientFrom(String payload) {
        if (payload.startsWith(MAGIC) && payload.length() > MAGIC.length()) {
            payload = payload.substring(MAGIC.length());
            int i = payload.indexOf(SEPARATOR);
            return payload.substring(0, i);
        }
        return null;
    }
}

