/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache;

import java.io.IOException;
import org.apache.jackrabbit.oak.segment.spi.monitor.FileStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;
import org.apache.jackrabbit.oak.segment.spi.monitor.RemoteStoreMonitor;
import org.apache.jackrabbit.oak.segment.spi.persistence.GCJournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.JournalFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.ManifestFile;
import org.apache.jackrabbit.oak.segment.spi.persistence.RepositoryLock;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.SegmentNodeStorePersistence;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.CachingArchiveManager;
import org.apache.jackrabbit.oak.segment.spi.persistence.persistentcache.PersistentCache;

public class CachingPersistence
implements SegmentNodeStorePersistence {
    private final SegmentNodeStorePersistence delegate;
    private final PersistentCache persistentCache;

    public CachingPersistence(PersistentCache persistentCache, SegmentNodeStorePersistence delegate) {
        this.delegate = delegate;
        this.persistentCache = persistentCache;
    }

    @Override
    public SegmentArchiveManager createArchiveManager(boolean memoryMapping, boolean offHeapAccess, IOMonitor ioMonitor, FileStoreMonitor fileStoreMonitor, RemoteStoreMonitor remoteStoreMonitor) throws IOException {
        return new CachingArchiveManager(this.persistentCache, this.delegate.createArchiveManager(memoryMapping, offHeapAccess, ioMonitor, fileStoreMonitor, remoteStoreMonitor));
    }

    @Override
    public boolean segmentFilesExist() {
        return this.delegate.segmentFilesExist();
    }

    @Override
    public JournalFile getJournalFile() {
        return this.delegate.getJournalFile();
    }

    @Override
    public GCJournalFile getGCJournalFile() throws IOException {
        return this.delegate.getGCJournalFile();
    }

    @Override
    public ManifestFile getManifestFile() throws IOException {
        return this.delegate.getManifestFile();
    }

    @Override
    public RepositoryLock lockRepository() throws IOException {
        return this.delegate.lockRepository();
    }
}

